/*
 * Cueplot: a GUI front-end to gnuplot
 * Copyright (C) 2007 Muneyuki Noguchi
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation, 
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */
#ifndef OUTPUT_OPTION_WIDGET_INCLUDED
#define OUTPUT_OPTION_WIDGET_INCLUDED

#include "OptionWidget.h"

class FileLineEdit;
class Output;

class QCheckBox;
class QPushButton;

// set output コマンドのオプションを扱うウィジェット
class OutputOptionWidget : public OptionWidget
{
	Q_OBJECT

	public:
		explicit OutputOptionWidget(QWidget *parent = 0);
		~OutputOptionWidget();

		void construct();

	private slots:
		void setOutput();

	private:
		// don't implement these
		OutputOptionWidget(const OutputOptionWidget &);
		OutputOptionWidget &operator=(const OutputOptionWidget &);

		void init();
		void apply();
		void setWidget();
		Output *output;
		QCheckBox *defaultCheckBox;
		FileLineEdit *fileLineEdit;
		QPushButton *fileNamePushButton;
};
#endif // OUTPUT_OPTION_WIDGET_INCLUDED
