/*
 * Cueplot: a GUI front-end to gnuplot
 * Copyright (C) 2007 Muneyuki Noguchi
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation, 
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */
#include "PlotRange.h"

PlotRange::PlotRange() : isParametric_(false)
{
	for (int i = 0; i < 3; i++) {
		dummyVarArray[i] = "";
		minArray[i] = "";
		maxArray[i] = "";
	}
}

void PlotRange::setParametric(bool isParametric)
{
	isParametric_ = isParametric;
}

bool PlotRange::isParametric() const
{
	return isParametric_;
}

void PlotRange::setDummyVariable(int axis, const QString &var)
{
	dummyVarArray[axis] = var;
}

const QString &PlotRange::dummyVariable(int axis) const
{
	return dummyVarArray[axis];
}

void PlotRange::setMinimum(int axis, const QString &min)
{
	minArray[axis] = min;
}

const QString &PlotRange::minimum(int axis) const
{
	return minArray[axis];
}

void PlotRange::setMaximum(int axis, const QString &max)
{
	maxArray[axis] = max;
}

const QString &PlotRange::maximum(int axis) const
{
	return maxArray[axis];
}

QString PlotRange::option() const
{
	QString str;
	int beginNum = !isParametric_;
	for (int i = beginNum; i < AXIS_NUM; i++) {
		bool hasDummy = ((i == beginNum) && !dummyVarArray[i].isEmpty());
		bool hasEnd = (!minArray[i].isEmpty() || !maxArray[i].isEmpty());
		if (!hasDummy && !hasEnd) {
			continue;
		}
		str += "[";
		if (hasDummy) {
			str += dummyVarArray[i] + "=";
		}
		if (hasEnd) {
			str += minArray[i] + ":" + maxArray[i];
		}
		str += "]";
	}
	return str;
}
