/*
 * Cueplot: a GUI front-end to gnuplot
 * Copyright (C) 2007 Muneyuki Noguchi
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation, 
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */
#ifndef PLOT_INPUT_WIDGET_INCLUDED
#define PLOT_INPUT_WIDGET_INCLUDED

class FileLineEdit;
class Plot;

#include <QtGui/QWidget>
class QRadioButton;
class QLineEdit;

//! プロットする項目を入力するためのウィジェット
class PlotInputWidget : public QWidget
{
	Q_OBJECT

	public:
		explicit PlotInputWidget(QWidget *parent = 0);

	private slots:
		//! 項目を追加する
		void addData();

	private slots:
		//! データファイルを開く
		void openDataFile();
		//! 項目の追加元を切り替える
		void changeInput();

	signals:
		/*!
		 * \brief このシグナルは項目が追加されるときに発信される
		 * \param plot 追加される Plot クラスのオブジェクト
		 */
		void dataAdded(const Plot &plot);
		/*!
		 * \brief このシグナルは項目の入力元が変更されるときに発信される
		 * \param notEmpty 新しい入力元の中に文字が含まれるときは true
		 */
		void inputChanged(bool notEmpty);

	private:
		// don't implement these
		PlotInputWidget(const PlotInputWidget &);
		PlotInputWidget &operator=(const PlotInputWidget &);

		QRadioButton *filenameRadioButton;
		FileLineEdit *filenameLineEdit;
		QRadioButton *functionRadioButton;
		QLineEdit *functionLineEdit;
};
#endif // PLOT_INPUT_WIDGET_INCLUDED
