/*
 * Cueplot: a GUI front-end to gnuplot
 * Copyright (C) 2008 Muneyuki Noguchi
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation, 
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */
#ifndef PLOT_LIST_MODEL_INCLUDED
#define PLOT_LIST_MODEL_INCLUDED

#include "Plot.h"

#include <QtGui/QListWidget>

//! プロットする項目を格納する List Model
class PlotListModel : public QAbstractListModel
{
	Q_OBJECT

	public:
		explicit PlotListModel(QObject *parent = 0);

		QVariant data(const QModelIndex &index, 
				int role = Qt::DisplayRole) const;
		bool dropMimeData(const QMimeData *data, Qt::DropAction action,
				int row, int column, const QModelIndex &parent);
		QVariant headerData(int section, Qt::Orientation orientation,
				int role = Qt::DisplayRole) const;
		Qt::ItemFlags flags(const QModelIndex &index) const;
		bool insertRows(int row, int count, 
				const QModelIndex &parent = QModelIndex());
		QStringList mimeTypes() const;
		bool removeRows(int row, int count, 
				const QModelIndex &parent = QModelIndex());
		int rowCount(const QModelIndex &parent = QModelIndex()) const;
		bool setData(const QModelIndex &index, const QVariant &value, 
				int role = Qt::EditRole);
		Qt::DropActions supportedDropActions() const;
		/*!
		 * \brief 項目を交換する
		 * \param row1 交換する項目
		 * \param row2 交換する項目
		 * \param parent 親項目
		 */
		bool swapRow(int row1, int row2, 
				const QModelIndex &parent = QModelIndex());
		/*!
		 * \brief 指定したインデックスに対するオプションを得る
		 * \param index インデックス
		 */
		Plot plot(const QModelIndex &index) const;
		/*!
		 * \brief 指定したインデックスに対するオプションを設定する
		 * \param index インデックス
		 * \param plot オプション
		 */
		bool setPlot(const QModelIndex &index, const Plot &plot);

	private:
		// don't implement these
		PlotListModel(const PlotListModel &);
		PlotListModel &operator=(const PlotListModel &);

		//! オプションを格納するリスト
		QList<Plot> plotList;
		//! チェックボックスの状態を格納するリスト
		QList<Qt::CheckState> checkList;
};
#endif // PLOT_LIST_MODEL_INCLUDED
