/*
 * Cueplot: a GUI front-end to gnuplot
 * Copyright (C) 2007, 2008 Muneyuki Noguchi
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation, 
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */
#include "BoxWidthOptionWidget.h"
#include "BoxWidth.h"

#include <QtGui/QCheckBox>
#include <QtGui/QDoubleSpinBox>
#include <QtGui/QGridLayout>
#include <QtGui/QGroupBox>
#include <QtGui/QVBoxLayout>

BoxWidthOptionWidget::BoxWidthOptionWidget(QWidget *parent)
: OptionWidget(parent), boxWidth(0)
{
	setWindowTitle(tr("Box Width"));
}

BoxWidthOptionWidget::~BoxWidthOptionWidget()
{
	delete boxWidth;
}

void BoxWidthOptionWidget::construct()
{
	setWhatsThis("set boxwidth");

	absoluteCheckBox = new QCheckBox;
	absoluteCheckBox->setText(tr("\"A&bsolute\" value"));
	connect(absoluteCheckBox, SIGNAL(toggled(bool)),
			this, SIGNAL(modified()));

	boxWidthDoubleSpinBox = new QDoubleSpinBox;
	boxWidthDoubleSpinBox->setMinimum(-99);
	connect(boxWidthDoubleSpinBox, SIGNAL(valueChanged(double)),
			this, SIGNAL(modified()));

	QGridLayout *defaultLayout = new QGridLayout;
	defaultLayout->addWidget(absoluteCheckBox, 0, 0);
	defaultLayout->addItem(new QSpacerItem(40, 20,
				QSizePolicy::Expanding, QSizePolicy::Minimum), 0, 1);
	defaultLayout->addWidget(boxWidthDoubleSpinBox, 1, 0);

	defaultGroupBox = new QGroupBox;
	defaultGroupBox->setLayout(defaultLayout);
	defaultGroupBox->setTitle(tr("&Specify"));
	defaultGroupBox->setCheckable(true);
	connect(defaultGroupBox, SIGNAL(toggled(bool)),
			this, SIGNAL(modified()));
	connect(defaultGroupBox, SIGNAL(toggled(bool)),
			absoluteCheckBox, SLOT(setEnabled(bool)));
	connect(defaultGroupBox, SIGNAL(toggled(bool)),
			boxWidthDoubleSpinBox, SLOT(setEnabled(bool)));

	QVBoxLayout *mainLayout = new QVBoxLayout;
	mainLayout->addWidget(defaultGroupBox);
	mainLayout->addStretch();

	setLayout(mainLayout);
}

void BoxWidthOptionWidget::init()
{
	delete boxWidth;
	boxWidth = new BoxWidth;
	setWidget();
}

void BoxWidthOptionWidget::apply()
{
	boxWidth->setWidth(boxWidthDoubleSpinBox->value());
	boxWidth->setAbsolute(absoluteCheckBox->isChecked());
	boxWidth->setAuto(!defaultGroupBox->isChecked());

	emit executed(boxWidth->command());
}

void BoxWidthOptionWidget::setWidget()
{	
	bool flag = boxWidth->isAuto();
	defaultGroupBox->setChecked(!flag);
	boxWidthDoubleSpinBox->setEnabled(!flag);
	absoluteCheckBox->setEnabled(!flag);

	boxWidthDoubleSpinBox->setValue(boxWidth->width());
	absoluteCheckBox->setChecked(boxWidth->isAbsolute());
}
