/*
 * Cueplot: a GUI front-end to gnuplot
 * Copyright (C) 2007, 2008 Muneyuki Noguchi
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation, 
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */
#include "SamplesOptionWidget.h"
#include "Samples.h"

#include <QtGui/QGridLayout>
#include <QtGui/QLabel>
#include <QtGui/QSpinBox>

#include <limits> // max()

SamplesOptionWidget::SamplesOptionWidget(QWidget *parent)
: OptionWidget(parent), samples(0)
{
	setWindowTitle(tr("Sampling"));
}

SamplesOptionWidget::~SamplesOptionWidget()
{
	delete samples;
}

void SamplesOptionWidget::construct()
{
	setWhatsThis("set samples");

	oneSpinBox = new QSpinBox;
	oneSpinBox->setMaximum(std::numeric_limits<int>::max());
	connect(oneSpinBox, SIGNAL(valueChanged(int)),
			this, SIGNAL(modified()));

	QLabel *oneLabel = new QLabel;
	oneLabel->setText(tr("Samples") + " &1:");
	oneLabel->setBuddy(oneSpinBox);

	twoSpinBox = new QSpinBox;
	twoSpinBox->setMaximum(std::numeric_limits<int>::max());
	connect(twoSpinBox, SIGNAL(valueChanged(int)),
			this, SIGNAL(modified()));

	QLabel *twoLabel = new QLabel;
	twoLabel->setText(tr("Samples") + " &2:");
	twoLabel->setBuddy(twoSpinBox);

	QGridLayout *mainLayout = new QGridLayout;
	mainLayout->addWidget(oneLabel, 0, 0);
	mainLayout->addWidget(oneSpinBox, 0, 1);
	mainLayout->addWidget(twoLabel, 1, 0);
	mainLayout->addWidget(twoSpinBox, 1, 1);
	mainLayout->addItem(new QSpacerItem(40, 20, 
				QSizePolicy::Expanding, QSizePolicy::Minimum), 0, 2);
	mainLayout->addItem(new QSpacerItem(20, 40,
				QSizePolicy::Minimum, QSizePolicy::Expanding), 2, 0);

	setLayout(mainLayout);
}

void SamplesOptionWidget::init()
{
	delete samples;
	samples = new Samples;
	setWidget();
}

void SamplesOptionWidget::apply()
{
	samples->setSamples1(oneSpinBox->value());
	samples->setSamples2(twoSpinBox->value());
	emit executed(samples->command());
}

void SamplesOptionWidget::setWidget()
{
	oneSpinBox->setValue(samples->samples1());
	twoSpinBox->setValue(samples->samples2());
}
