/*
 * Cueplot: a GUI front-end to gnuplot
 * Copyright (C) 2007, 2008 Muneyuki Noguchi
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation, 
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */
#include "StyleFunctionOptionWidget.h"
#include "StyleFunction.h"

#include <QtGui/QGridLayout>
#include <QtGui/QComboBox>

StyleFunctionOptionWidget::StyleFunctionOptionWidget(QWidget *parent)
: OptionWidget(parent), styleFunction(0)
{
}

StyleFunctionOptionWidget::~StyleFunctionOptionWidget()
{
	delete styleFunction;
}

void StyleFunctionOptionWidget::construct()
{
	setWhatsThis("set style function");

	styleComboBox = new QComboBox;
	for (int i = 0; !StyleFunction::PLOTTING_STYLE[i].isEmpty(); i++) {
		styleComboBox->addItem(StyleFunction::PLOTTING_STYLE[i]);
	}
	connect(styleComboBox, SIGNAL(activated(int)),
			this, SIGNAL(modified()));

	QGridLayout *mainLayout = new QGridLayout;
	mainLayout->addWidget(styleComboBox, 0, 0);
	mainLayout->addItem(new QSpacerItem(40, 20, 
				QSizePolicy::Expanding, QSizePolicy::Minimum), 0, 1);
	mainLayout->addItem(new QSpacerItem(20, 40,
				QSizePolicy::Minimum, QSizePolicy::Expanding), 1, 0);

	setLayout(mainLayout);
}

void StyleFunctionOptionWidget::init()
{
	delete styleFunction;
	styleFunction = new StyleFunction;
	setWidget();
}

void StyleFunctionOptionWidget::apply()
{
	styleFunction->setPlottingStyle(styleComboBox->currentIndex());
	emit executed(styleFunction->command());
}

void StyleFunctionOptionWidget::setWidget()
{
	styleComboBox->setCurrentIndex(styleFunction->plottingStyle());
}
