/*
 * Cueplot: a GUI front-end to gnuplot
 * Copyright (C) 2007, 2008 Muneyuki Noguchi
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation, 
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */
#include "TerminalPbmOptionWidget.h"
#include "TerminalPbm.h"

#include <QtCore/QCoreApplication>
#include <QtGui/QComboBox>
#include <QtGui/QGridLayout>
#include <QtGui/QLabel>

TerminalPbmOptionWidget::TerminalPbmOptionWidget(QWidget *parent)
: OptionWidget(parent), terminalPbm(0)
{
}

TerminalPbmOptionWidget::~TerminalPbmOptionWidget()
{
	delete terminalPbm;
}

void TerminalPbmOptionWidget::construct()
{
	fontSizeComboBox = new QComboBox;
	for (int i = 0; TerminalPbm::FONT_SIZE[i][0]; i++) {
		fontSizeComboBox->addItem(QCoreApplication::translate(
						"TerminalPbm", TerminalPbm::FONT_SIZE[i]));
	}
	connect(fontSizeComboBox, SIGNAL(activated(int)),
			this, SIGNAL(modified()));

	QLabel *fontSizeLabel = new QLabel;
	fontSizeLabel->setText(tr("&Font size:"));
	fontSizeLabel->setBuddy(fontSizeComboBox);

	colorModeComboBox = new QComboBox;
	for (int i = 0; TerminalPbm::MODE[i][0]; i++) {
		colorModeComboBox->addItem(QCoreApplication::translate(
						"TerminalPbm", TerminalPbm::MODE[i]));
	}
	connect(colorModeComboBox, SIGNAL(activated(int)),
			this, SIGNAL(modified()));

	QLabel *colorModeLabel = new QLabel;
	colorModeLabel->setText(tr("Co&lormode:"));
	colorModeLabel->setBuddy(colorModeComboBox);

	QGridLayout *mainLayout = new QGridLayout;
	mainLayout->addWidget(fontSizeLabel, 0, 0);
	mainLayout->addWidget(fontSizeComboBox, 0, 1);
	mainLayout->addItem(new QSpacerItem(40, 20, 
				QSizePolicy::Expanding, QSizePolicy::Minimum), 0, 2);
	mainLayout->addWidget(colorModeLabel, 1, 0);
	mainLayout->addWidget(colorModeComboBox, 1, 1);
	mainLayout->addItem(new QSpacerItem(20, 40,
				QSizePolicy::Minimum, QSizePolicy::Expanding), 2, 0);

	setLayout(mainLayout);
}

void TerminalPbmOptionWidget::init()
{
	delete terminalPbm;
	terminalPbm = new TerminalPbm;
	setWidget();
}

void TerminalPbmOptionWidget::apply()
{
	terminalPbm->setFontSize(fontSizeComboBox->currentIndex());
	terminalPbm->setMode(colorModeComboBox->currentIndex());

	emit executed(terminalPbm->command());
}

void TerminalPbmOptionWidget::setWidget()
{
	fontSizeComboBox->setCurrentIndex(terminalPbm->fontSize());
	colorModeComboBox->setCurrentIndex(terminalPbm->mode());
}
