/*
 * Cueplot: a GUI front-end to gnuplot
 * Copyright (C) 2007 Muneyuki Noguchi
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation, 
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */
#include "PlotOthersWidget.h"
#include "Plot.h"

#include <QtGui/QComboBox>
#include <QtGui/QGroupBox>
#include <QtGui/QHBoxLayout>
#include <QtGui/QVBoxLayout>

PlotOthersWidget::PlotOthersWidget(QWidget *parent)
: PlotOptionWidget(parent), axis_(0)
{
	setWindowTitle(tr("Others"));

	axisComboBox = new QComboBox;
	for (int i = 0; !Plot::AXIS[i].isEmpty(); i++) {
		axisComboBox->addItem(Plot::AXIS[i]);
	}

	QHBoxLayout *axisLayout = new QHBoxLayout;
	axisLayout->addWidget(axisComboBox);
	axisLayout->addStretch();

	axisGroupBox = new QGroupBox(tr("A&xes"));
	axisGroupBox->setWhatsThis(tr("plot {axes &lt;axes&gt;}"));
	axisGroupBox->setCheckable(true);
	axisGroupBox->setLayout(axisLayout);
	connect(axisGroupBox, SIGNAL(toggled(bool)),
			axisComboBox, SLOT(setEnabled(bool)));

	QVBoxLayout *mainLayout = new QVBoxLayout;
	mainLayout->addWidget(axisGroupBox);
	mainLayout->addStretch();

	setLayout(mainLayout);
}

void PlotOthersWidget::setPlotAxis(int axis)
{
	axis_ = axis;
	setWidget();
}

int PlotOthersWidget::plotAxis() const
{
	return axis_;
}

void PlotOthersWidget::apply()
{
	axis_ = axisGroupBox->isChecked() ? axisComboBox->currentIndex() : -1;
}

void PlotOthersWidget::setWidget()
{
	bool hasAxis = (axis_ >= 0);
	axisGroupBox->setChecked(hasAxis);
	axisComboBox->setEnabled(hasAxis);
	if (hasAxis) {
		axisComboBox->setCurrentIndex(axis_);
	}
}
