/*
 * Cueplot: a GUI front-end to gnuplot
 * Copyright (C) 2007 Muneyuki Noguchi
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation, 
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */
#ifndef PLOT_TITLE_WIDGET_INCLUDED
#define PLOT_TITLE_WIDGET_INCLUDED

#include "PlotOptionWidget.h"

class PlotTitle;

class QLineEdit;
class QRadioButton;

class PlotTitleWidget : public PlotOptionWidget
{
	Q_OBJECT

	public:
		explicit PlotTitleWidget(QWidget *parent = 0);
		~PlotTitleWidget();

		void setPlotTitle(const PlotTitle &plotTitle);
		const PlotTitle &plotTitle() const;

		void apply();

	private:
		// don't implement these
		PlotTitleWidget(const PlotTitleWidget &);
		PlotTitleWidget &operator=(const PlotTitleWidget &);

		void setWidget();

		PlotTitle *plotTitle_;
		QRadioButton *defaultTitleRadioButton;
		QRadioButton *noTitleRadioButton;
		QRadioButton *customTitleRadioButton;
		QLineEdit *titleLineEdit;
};
#endif // PLOT_TITLE_WIDGET_INCLUDED
