/*
 * Cueplot: a GUI front-end to gnuplot
 * Copyright (C) 2007 Muneyuki Noguchi
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation, 
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */
#include "Bar.h"

#include <QtCore/QString>

const double Bar::SMALL = 0.0;
const double Bar::LARGE = 1.0;

Bar::Bar() : size_(1.000000)
{
}

void Bar::setSmall(bool small)
{
	size_ = small ? SMALL : LARGE;
}

bool Bar::isSmall() const
{
	return size_ == SMALL;
}

void Bar::setBig(bool big)
{
	setSmall(!big);
}

bool Bar::isBig() const
{
	return size_ == LARGE;
}

void Bar::setSize(double size)
{
	size_ = size;
}

double Bar::size() const
{
	return size_;
}

QString Bar::command() const
{
	return "set bar " + QString::number(size_);
}
