/*
 * Cueplot: a GUI front-end to gnuplot
 * Copyright (C) 2007 Muneyuki Noguchi
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation, 
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */
#ifndef TERMINAL_INCLUDED
#define TERMINAL_INCLUDED

#include "Option.h"

#include <QtCore/QString>

//! set terminal コマンド
class Terminal : public Option
{
	public:
		Terminal();

		void setTerminalType(const QString &type);
		const QString &terminalType() const;

		void setPush();
		void setPop();

		QString command() const;

		static const QString TERMINALS[];
		static const QString TERMINALS_WITH_OPTIONS[];
	protected:
		QString terminalType_;
		virtual QString terminalOption() const;
	private:
		static const int TERMINAL = 0;
		static const int PUSH = 1;
		static const int POP = 2;
		int status;
};
#endif // TERMINAL_INCLUDED
