/*
 * Cueplot: a GUI front-end to gnuplot
 * Copyright (C) 2007 Muneyuki Noguchi
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation, 
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */
#ifndef VIEW_INCLUDED
#define VIEW_INCLUDED

#include "Option.h"

//! set view コマンド
class View : public Option
{
	public:
		View();

		void setMap(bool map);
		bool isMap() const;

		void setRotationX(double x);
		double rotationX() const;

		void setRotationZ(double z);
		double rotationZ() const;

		void setScaling(double s);
		double scaling() const;

		void setScalingZ(double sZ);
		double scalingZ() const;

		QString command() const;

	private:
		bool isMap_;
		double rotX;
		double rotZ;
		double scale;
		double scaleZ;
};
#endif // VIEW_INCLUDED
