/*
 * Cueplot: a GUI front-end to gnuplot
 * Copyright (C) 2007 Muneyuki Noguchi
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation, 
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */
#ifndef PLOT_STYLE_WIDGET_INCLUDED
#define PLOT_STYLE_WIDGET_INCLUDED

#include "PlotOptionWidget.h"

class PlotStyle;

class QCheckBox;
class QComboBox;
class QDoubleSpinBox;
class QSpinBox;

class PlotStyleWidget : public PlotOptionWidget
{
	Q_OBJECT

	public:
		explicit PlotStyleWidget(QWidget *parent = 0);
		~PlotStyleWidget();

		void setPlotStyle(const PlotStyle &plotStyle);
		const PlotStyle &plotStyle() const;

		void apply();

	private slots:
		/*! 
		 * \brief 「指定する」チェックボックスの状態が変えられたときに
		 * 他のチェックボックスとスピンボックスの状態を設定する
		 * \param isEnabled チェックボックスが有効化されたときは true
		 */
		void setWidget(bool isEnabled);

	private:
		// don't implement these
		PlotStyleWidget(const PlotStyleWidget &);
		PlotStyleWidget &operator=(const PlotStyleWidget &);

		void setWidget();

		PlotStyle *plotStyle_;
		QCheckBox *styleCheckBox;
		QComboBox *styleComboBox;
		QCheckBox *lineTypeCheckBox;
		QSpinBox *lineTypeSpinBox;
		QCheckBox *lineWidthCheckBox;
		QDoubleSpinBox *lineWidthDoubleSpinBox;
		QCheckBox *pointTypeCheckBox;
		QSpinBox *pointTypeSpinBox;
		QCheckBox *pointSizeCheckBox;
		QDoubleSpinBox *pointSizeDoubleSpinBox;
};
#endif // PLOT_STYLE_WIDGET_INCLUDED
