/*
 * Aipo is a groupware program developed by Aimluck,Inc.
 * http://aipostyle.com/
 * 
 * Copyright(C) 2009 avanza Co.,Ltd. All rights reserved.
 * http://www.avnz.co.jp/
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */
package com.aimluck.eip.modules.actions.rss;

import org.apache.jetspeed.portal.portlets.VelocityPortlet;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

import com.aimluck.eip.modules.actions.common.ALBaseAction;
import com.aimluck.eip.rss.RssSelectData;

/**
 * RSSのアクションクラスです。<BR>
 * 
 */
public class RssAction extends ALBaseAction {

  /** logger */
  private static final JetspeedLogger logger = JetspeedLogFactoryService
      .getLogger(RssAction.class.getName());

  /**
   * 通常表示の際の処理を記述します。<BR>
   * 
   * @param portlet
   * @param context
   * @param rundata
   * @throws java.lang.Exception
   * @see org.apache.jetspeed.modules.actions.portlets.VelocityPortletAction#buildNormalContext(org.apache.jetspeed.portal.portlets.VelocityPortlet,
   *      org.apache.velocity.context.Context, org.apache.turbine.util.RunData)
   */
  @Override
  protected void buildNormalContext(VelocityPortlet portlet, Context context,
      RunData rundata) throws Exception {

    if (getMode() == null) {
      doRss_list(portlet, rundata, context);
    }

  }

  /**
   * 最大化表示の際の処理を記述します。<BR>
   * @param portlet
   * @param context
   * @param rundata
   * @see org.apache.jetspeed.modules.actions.portlets.VelocityPortletAction#buildMaximizedContext(org.apache.jetspeed.portal.portlets.VelocityPortlet,
   *      org.apache.velocity.context.Context, org.apache.turbine.util.RunData)
   */
  @Override
  protected void buildMaximizedContext(VelocityPortlet portlet,
      Context context, RunData rundata) {

    // MODEを取得
    //String mode = rundata.getParameters().getString(ALEipConstants.MODE);
    try {
      //if (ALEipConstants.MODE_LIST.equals(mode)) {
      //  doMylink_list(portlet, rundata, context);
      //  setTemplate(rundata, "rss-list");
      //}
      if (getMode() == null) {
        doRss_list(portlet, rundata, context);
        setTemplate(rundata, "rss-list");
      }
    } catch (Exception ex) {
      logger.error("Exception", ex);
    }
  }

  /**
   * 記事一覧を表示します。
   * @param rundata
   * @param context
   */
  public void doRss_list(VelocityPortlet portlet, RunData rundata, Context context) throws Exception {
    RssSelectData listData = new RssSelectData();
    listData.initField();
    listData.setRowsNum(Integer.parseInt(portlet.getPortletConfig()
        .getInitParameter("pbb-rows")));
    listData.setStrLength(Integer.parseInt(portlet.getPortletConfig()
        .getInitParameter("pba-strlen")));
    listData.loadUrlList(portlet, rundata);
    listData.doViewList(this, rundata, context);
  }
}
