/*
 * Aipo is a groupware program developed by Aimluck,Inc.
 * http://aipostyle.com/
 * 
 * Copyright(C) 2009 avanza Co.,Ltd. All rights reserved.
 * http://www.avnz.co.jp/
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */
package com.aimluck.eip.modules.parameters;

import java.util.Iterator;
import java.util.List;

import org.apache.jetspeed.modules.parameters.ListBox;
import org.apache.jetspeed.portal.controls.VelocityPortletControl;
import org.apache.turbine.util.RunData;

import com.aimluck.eip.rss.UrlResultData;
import com.aimluck.eip.rss.util.RssUtils;

/**
 * RSSの設定値を処理するクラスです。 <br />
 * カスタマイズ画面のFeedプルダウン表示用クラスです。
 * @author T.Motegi
 */
public class UrlListBox extends ListBox {

  public static final String INITIAL_VALUE = "initialvalue";

  private String DEF_INITIAL_VALUE = "";

  /**
   * Initialize options
   * 
   * @param data
   */
  @Override
  protected void init(RunData data) {
   
    VelocityPortletControl portlet = (VelocityPortletControl)this.getParm("portlet", "");
    
    //psmlファイルから設定されているRSSフィードの一覧を取得します。
    List<UrlResultData> titles = RssUtils.getTitles(portlet.getPortletConfig(), data);
    
    int length = titles.size() + 1;
    String[] urlKeys = new String[length];
    String[] urlValues = new String[length];

    urlKeys[0] = "all";
    urlValues[0] = (String) this.getParm(INITIAL_VALUE, DEF_INITIAL_VALUE);
    
    Iterator<UrlResultData> iter = titles.iterator();
    int count = 1;
    while (iter.hasNext()) {
      UrlResultData rd = iter.next();
      urlKeys[count] = rd.getNo().getValue();
      urlValues[count] = rd.getTitle().getValue();
      count++;
    }
    
    //カスタマイズ画面へデータを返します。
    this.layout = (String) this.getParm(LAYOUT, LAYOUT_COMBO);
    this.items = urlKeys;
    this.values = urlValues;
    this.size = Integer.toString(length);
    this.multiple = Boolean.valueOf(
        (String) this.getParm(MULTIPLE_CHOICE, "false")).booleanValue();
  }
}
