/* ====================================================================
 * The Apache Software License, Version 1.1
 *
 * Copyright (c) 2001 The Apache Software Foundation.  All rights
 * reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * 3. The end-user documentation included with the redistribution,
 *    if any, must include the following acknowledgment:
 *       "This product includes software developed by the
 *        Apache Software Foundation (http://www.apache.org/)."
 *    Alternately, this acknowledgment may appear in the software itself,
 *    if and wherever such third-party acknowledgments normally appear.
 *
 * 4. The names "Apache" and "Apache Software Foundation" and
 *    "Apache Jetspeed" must not be used to endorse or promote products
 *    derived from this software without prior written permission. For
 *    written permission, please contact apache@apache.org.
 *
 * 5. Products derived from this software may not be called "Apache",
 *    "Apache Jetspeed", nor may "Apache" appear in their name, without
 *    prior written permission of the Apache Software Foundation.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL THE APACHE SOFTWARE FOUNDATION OR
 * ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 * ====================================================================
 *
 * This software consists of voluntary contributions made by many
 * individuals on behalf of the Apache Software Foundation.  For more
 * information on the Apache Software Foundation, please see
 * <http://www.apache.org/>.
 */
package org.apache.jetspeed.om.cms.slide;

import org.apache.turbine.util.Log;

import org.apache.jetspeed.om.cms.*;


/**
 * <p> Wrapper class for a content Item (ObjectNode).<br>
 * Used to access to the content attributes
 *
 * @author <a href="mailto:christophe.lombart@skynet.be">Christophe Lombart</a>
 *
 */

public class SlideContentItem extends SlideResource implements ContentItem
{
	private String logicalName = "";
	private String description = "";
	private String contentType= "";            // URL, HTML Text or upload// if contentType = URL => external or portal link
	private String contentReference = "";  // url or HTML content
	private String contentClass="" ; // Application or Document
	private String title = "";
	private String author = "";
	private Integer creationDate_year;
	private Integer creationDate_month;
	private Integer creationDate_day;
	private String parentUri;

	public static String TYPE = "ContentItem";

	/**
	* getKey() : use in the comparator defined in the Catalog.java class
	*/
	public String getKey()
	{
		return "2" + this.getTitle( ); // "2" because the contentItem should
									 // after the catalogs reference
	}

	public boolean contentTypeisURLPortal()
	{
		String type = this.getContentType();

		if (type == null)
		{
			return false;
		}

		return type.equals("URLPORT");
	}

	public boolean contentTypeisURLInternet()
	{
		String type = this.getContentType();

		if (type == null)
		{
			return false;
		}

		return type.equals("URLINT");
	}

	public boolean contentTypeisHTML()
	{
		String type = this.getContentType();

		if (type == null)
		{
			return false;
		}

		return type.equals("HTML");
	}

	public boolean contentTypeisUpload()
	{
		String type = this.getContentType();

		if (type == null)
		{
			return false;
		}

		return type.equals("UPLOAD");
	}

	public void setContentClass(String contentClass)
	{
		if (descriptor != null)
		{
			descriptor.setProperty("contentClass", contentClass);
		}

 		this.contentClass = contentClass;
	}

	public String getContentClass()
	{
		if ((descriptor != null) && ((this.contentClass == null) || (this.contentClass.equals(""))))
		{
			this.contentClass = (String) this.getProperty("contentClass");
		}

		return this.contentClass;
	}

	public void setLogicalName(String logicalName)
	{
		if (descriptor != null)
		{
			descriptor.setProperty("logicalName", logicalName);
		}

		this.logicalName = logicalName;
	}

	public String getLogicalName()
	{

		if (Log.getLogger().isDebugEnabled())
		{
			Log.debug("ContentItem.getLogicalName() :" + this.uri);
		}

		if ((descriptor != null) && ((this.logicalName == null) || (this.logicalName.equals(""))))
		{
			this.logicalName = (String) this.getProperty("logicalName");
		}

		return this.logicalName;
	}

	public void setDescription(String description)
	{
		if (descriptor != null)
		{
			descriptor.setProperty("description", description);
		}

		this.description = description;
	}

	public String getDescription()
	{
		if ((descriptor != null) && ((this.description == null) || (this.description.equals(""))))
		{
			this.description = (String) this.getProperty("description");
		}

		return this.description;
	}

	public void setContentType(String contentType)
	{
		if (descriptor != null)
		{
			descriptor.setProperty("contentType", contentType);
		}

		this.contentType = contentType;
	}

	public String getContentType()
	{
		if ((descriptor != null) && ((this.contentType == null) || (this.contentType.equals(""))))
		{
			this.contentType = (String) this.getProperty("contentType");
		}

		return this.contentType;
	}

	public void setContentReference(String contentReference)
	{
		if (descriptor != null)
		{
			descriptor.setProperty("contentReference", contentReference);
		}
	  this.contentReference = contentReference;
	}

	public String getContentReference()
	{
		if ((descriptor != null) && ((this.contentReference == null) || (this.contentReference.equals(""))))
		{
			this.contentReference = (String) this.getProperty("contentReference");
		}

		return this.contentReference;
	}

	public void setTitle(String title)
	{
		if (descriptor != null)
		{
			descriptor.setProperty("title", title);
		}

		this.title = title;
	}

	public String getTitle()
	{
		if ((descriptor != null) && ((this.title == null) || (this.title.equals(""))))
		{
			this.title = (String) this.getProperty("title");
		}

		return this.title;
	}

	public void setAuthor(String author)
	{
		if (descriptor != null)
		{
			descriptor.setProperty("author", author);
		}

		this.author = author;
	}

	public String getAuthor()
	{
		if ((descriptor != null) && ((this.author == null) || (this.author.equals(""))))
		{
			this.author = (String) this.getProperty("author");
		}

		return this.author;
	}

	public void setCreationDate_year(Integer creationDate_year)
	{
		if (descriptor != null)
		{
			descriptor.setProperty("creationDate_year", creationDate_year);
		}

		this.creationDate_year = creationDate_year;
	}

	public Integer getCreationDate_year()
	{
		if ((descriptor != null) && ((this.creationDate_year == null)))
		{
			this.creationDate_year = (Integer)this.getProperty("creationDate_year");
		}

		return this.creationDate_year;
	}

	public void setCreationDate_month(Integer creationDate_month)
	{
		if (descriptor != null)
		{
			descriptor.setProperty("creationDate_month", creationDate_month);
		}

		this.creationDate_month = creationDate_month;
	}

	public Integer getCreationDate_month()
	{
		if ((descriptor != null) && ((this.creationDate_month == null)))
		{
			this.creationDate_month = (Integer) this.getProperty("creationDate_month");
		}

		return this.creationDate_month;
	}

	public void setCreationDate_day(Integer creationDate_day)
	{
		if (descriptor != null)
		{
			descriptor.setProperty("creationDate_day", creationDate_day);
		}

		this.creationDate_day = creationDate_day;
	}

	public Integer getCreationDate_day()
	{
		if ((descriptor != null) && ((this.creationDate_day == null)))
		{
			this.creationDate_day = (Integer)this.getProperty("creationDate_day");
		}

		return this.creationDate_day;
	}

	public void setParentUri(String parentUri)
	{
		if (descriptor != null)
		{
			descriptor.setProperty("parentUri", parentUri);
		}

		this.parentUri = parentUri;
	}

	public String getParentUri()
	{
		if ((descriptor != null) && ((this.parentUri == null) || (this.parentUri.equals(""))))
		{
			this.parentUri = (String) this.getProperty("parentUri");
		}

		return this.parentUri;
	}

	public String getType()
	{
		return SlideContentItem.TYPE;
	}
}