/*
 * Copyright 2000-2004 The Apache Software Foundation.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.jetspeed.test;

// JUnit classes
import junit.framework.TestCase;

// Log4j classes
import org.apache.log4j.Logger;
import org.apache.log4j.Level;
import org.apache.log4j.ConsoleAppender;
import org.apache.log4j.SimpleLayout;

/**
 * @author <a href="mailto:harald@ommang.com">Harald Ommang</a>
 *
 * Base abstract class for testcases with static initialization used to
 * avoid Log4J configuration warnings
 *
 * @version $Id: JetspeedTestCase.java,v 1.1 2004/04/07 22:02:41 jford Exp $
 */
public abstract class JetspeedTestCase extends TestCase
{

	static
	{
		// Done
		ConsoleAppender ca = new ConsoleAppender(new SimpleLayout());
		Logger root = Logger.getRootLogger();
		root.setLevel(Level.INFO);
		root.addAppender(ca);
	}

	public JetspeedTestCase(String name)
	{
		super(name);
	}    
    
}

