/*
 * Copyright 2000-2004 The Apache Software Foundation.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.jetspeed.util;

import java.io.*;

// Junit imports
import junit.framework.Test;
import junit.framework.TestSuite;

import org.apache.turbine.util.StringUtils;
import org.apache.tools.ant.util.FileUtils;

// Jetspeed imports
import org.apache.jetspeed.test.JetspeedTestCase;

/**
 *
 * @author <a href="epugh@upstate.com">Eric Pugh</a>
 */

public class TestOverwriteProperties extends JetspeedTestCase
{

    private static String SRC_JETSPEED_RESOURCES = "test/testdata/conf/SrcJetspeedResources.properties";
    private static String JETSPEED_RESOURCES = "test/testdata/conf/JetspeedResources.properties";
    private static String MERGE_JETSPEED_RESOURCES = "test/testdata/conf/MergeJetspeedResources.properties";
    private static String MERGE_REMOVE_JETSPEED_RESOURCES = "test/testdata/conf/MergeRemoveJetspeedResources.properties";
    private static String MERGE_ADD_JETSPEED_RESOURCES = "test/testdata/conf/MergeAddJetspeedResources.properties";
    private static String RESULT_MERGE_JETSPEED_RESOURCES = "test/testdata/conf/ResultMergeJetspeedResources.properties";
    private static String RESULT_MERGE_REMOVE_JETSPEED_RESOURCES = "test/testdata/conf/ResultMergeRemoveJetspeedResources.properties";
    private static String RESULT_MERGE_ADD_JETSPEED_RESOURCES = "test/testdata/conf/ResultMergeAddJetspeedResources.properties";

    private static String INCLUDE_ROOT = "test/testdata/conf/";

    private File SRC_JETSPEED_RESOURCES_FILE = null;
    private File JETSPEED_RESOURCES_FILE = null;
    private File MERGE_JETSPEED_RESOURCES_FILE = null;
    private File MERGE_REMOVE_JETSPEED_RESOURCES_FILE = null;
    private File MERGE_ADD_JETSPEED_RESOURCES_FILE = null;
    private File RESULT_MERGE_JETSPEED_RESOURCES_FILE = null;
    private File RESULT_MERGE_REMOVE_JETSPEED_RESOURCES_FILE = null;
    private File RESULT_MERGE_ADD_JETSPEED_RESOURCES_FILE = null;

    private File INCLUDE_ROOT_DIR = null;

    private FileUtils fileUtils = FileUtils.newFileUtils();

    /**
     * Defines the testcase name for JUnit.
     *
     * @param name the testcase's name.
     */
    public TestOverwriteProperties( String name )
    {
        super( name );
    }

    /**
     * Start the tests.
     *
     * @param args the arguments. Not used
     */
    public static void main(String args[])
    {
        junit.awtui.TestRunner.main( new String[] { TestOverwriteProperties.class.getName()} );
    }

    /**
     * Creates the test suite.
     *
     * @return a test suite (<code>TestSuite</code>) that includes all methods
     *         starting with "test"
     */
    public static Test suite()
    {
        // All methods starting with "test" will be executed in the test suite.
        return new TestSuite( TestOverwriteProperties.class );
    }

    public void setUp() throws Exception{

        SRC_JETSPEED_RESOURCES_FILE = new File(SRC_JETSPEED_RESOURCES);

        assertTrue("Check SRC_JETSPEED_RESOURCES_FILE exists:" + SRC_JETSPEED_RESOURCES_FILE,SRC_JETSPEED_RESOURCES_FILE.exists());

        JETSPEED_RESOURCES_FILE = new File(JETSPEED_RESOURCES);

        if (JETSPEED_RESOURCES_FILE.exists())
        {
            assertTrue("Check JETSPEED_RESOURCES_FILE exists, then delete it:" + JETSPEED_RESOURCES_FILE,JETSPEED_RESOURCES_FILE.delete());
        }

        fileUtils.copyFile(SRC_JETSPEED_RESOURCES_FILE,JETSPEED_RESOURCES_FILE);

        assertTrue("Check JETSPEED_RESOURCES_FILE exists:" + JETSPEED_RESOURCES_FILE,JETSPEED_RESOURCES_FILE.exists());

        MERGE_JETSPEED_RESOURCES_FILE = new File(MERGE_JETSPEED_RESOURCES);

        assertTrue("Check MERGE_JETSPEED_RESOURCES_FILE exists:" + MERGE_JETSPEED_RESOURCES_FILE,MERGE_JETSPEED_RESOURCES_FILE.exists());

        MERGE_REMOVE_JETSPEED_RESOURCES_FILE = new File(MERGE_REMOVE_JETSPEED_RESOURCES);

        assertTrue("Check MERGE_REMOVE_JETSPEED_RESOURCES_FILE exists:" + MERGE_REMOVE_JETSPEED_RESOURCES_FILE,MERGE_REMOVE_JETSPEED_RESOURCES_FILE.exists());

        MERGE_ADD_JETSPEED_RESOURCES_FILE = new File(MERGE_ADD_JETSPEED_RESOURCES);

        assertTrue("Check MERGE_ADD_JETSPEED_RESOURCES_FILE exists:" + MERGE_ADD_JETSPEED_RESOURCES_FILE,MERGE_ADD_JETSPEED_RESOURCES_FILE.exists());

        RESULT_MERGE_JETSPEED_RESOURCES_FILE = new File(RESULT_MERGE_JETSPEED_RESOURCES);

        assertTrue("Check RESULT_MERGE_JETSPEED_RESOURCES_FILE exists:" + RESULT_MERGE_JETSPEED_RESOURCES_FILE,RESULT_MERGE_JETSPEED_RESOURCES_FILE.exists());

        RESULT_MERGE_REMOVE_JETSPEED_RESOURCES_FILE = new File(RESULT_MERGE_REMOVE_JETSPEED_RESOURCES);

        assertTrue("Check RESULT_MERGE_REMOVE_JETSPEED_RESOURCES_FILE exists:" + RESULT_MERGE_REMOVE_JETSPEED_RESOURCES_FILE,RESULT_MERGE_REMOVE_JETSPEED_RESOURCES_FILE.exists());

        RESULT_MERGE_ADD_JETSPEED_RESOURCES_FILE = new File(RESULT_MERGE_ADD_JETSPEED_RESOURCES);

        assertTrue("Check RESULT_MERGE_ADD_JETSPEED_RESOURCES_FILE exists:" + RESULT_MERGE_ADD_JETSPEED_RESOURCES_FILE,RESULT_MERGE_ADD_JETSPEED_RESOURCES_FILE.exists());

        INCLUDE_ROOT_DIR = new File(INCLUDE_ROOT);

        assertTrue("Check include root dir exists:" + INCLUDE_ROOT_DIR,INCLUDE_ROOT_DIR.exists());

        assertTrue(INCLUDE_ROOT_DIR.isDirectory());

    }

    /**
     * Tests overwriting property
     * @throws Exception
     */
    public void testOverwriteProperty() throws Exception
    {

        try
        {
            String args[] = new String[]{JETSPEED_RESOURCES_FILE.toString(),MERGE_JETSPEED_RESOURCES.toString(),INCLUDE_ROOT.toString()};
            OverwriteProperties.main(args);
            assertTrue("Make sure our merge worked properly.",fileUtils.contentEquals(JETSPEED_RESOURCES_FILE,RESULT_MERGE_JETSPEED_RESOURCES_FILE));
        }
        catch (Exception e)
        {
            fail(StringUtils.stackTrace(e));
        }
    }



    /**
     * Tests removing properties
     * @throws Exception
     */
    public void testRemoveProperties() throws Exception
    {
        try
        {
            String args[] = new String[]{JETSPEED_RESOURCES_FILE.toString(),MERGE_REMOVE_JETSPEED_RESOURCES.toString(),INCLUDE_ROOT.toString()};
            OverwriteProperties.main(args);
            assertTrue("Make sure our merge worked properly.",fileUtils.contentEquals(JETSPEED_RESOURCES_FILE,RESULT_MERGE_REMOVE_JETSPEED_RESOURCES_FILE));
        }
        catch (Exception e)
        {
            fail(StringUtils.stackTrace(e));
        }
    }

    /**
     * Tests adding properties
     * @throws Exception
     */
    public void testAddProperties() throws Exception
    {
        try
        {
            String args[] = new String[]{JETSPEED_RESOURCES_FILE.toString(),MERGE_ADD_JETSPEED_RESOURCES.toString(),INCLUDE_ROOT.toString()};
            OverwriteProperties.main(args);
            assertTrue("Make sure our merge worked properly.",fileUtils.contentEquals(JETSPEED_RESOURCES_FILE,RESULT_MERGE_ADD_JETSPEED_RESOURCES_FILE));
        }
        catch (Exception e)
        {
            fail(StringUtils.stackTrace(e));
        }
    }

    public void tearDown()
    {
        if (JETSPEED_RESOURCES_FILE.exists())
        {
            //JETSPEED_RESOURCES_FILE.delete();
        }
    }
}
