/* ====================================================================
 * The Apache Software License, Version 1.1
 *
 * Copyright (c) 2000-2001 The Apache Software Foundation.  All rights
 * reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * 3. The end-user documentation included with the redistribution,
 *    if any, must include the following acknowledgment:
 *       "This product includes software developed by the
 *        Apache Software Foundation (http://www.apache.org/)."
 *    Alternately, this acknowledgment may appear in the software itself,
 *    if and wherever such third-party acknowledgments normally appear.
 *
 * 4. The names "Apache" and "Apache Software Foundation" and
 *     "Apache Jetspeed" must not be used to endorse or promote products
 *    derived from this software without prior written permission. For
 *    written permission, please contact apache@apache.org.
 *
 * 5. Products derived from this software may not be called "Apache" or
 *    "Apache Jetspeed", nor may "Apache" appear in their name, without
 *    prior written permission of the Apache Software Foundation.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL THE APACHE SOFTWARE FOUNDATION OR
 * ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 * ====================================================================
 *
 * This software consists of voluntary contributions made by many
 * individuals on behalf of the Apache Software Foundation.  For more
 * information on the Apache Software Foundation, please see
 * <http://www.apache.org/>.
 */

package org.apache.jetspeed.portlet;

import org.apache.jetspeed.portlet.event.ActionListener;

/**
 * A <CODE>PortletURI</CODE> represents a URI to a specific portlet
 * function. A URI is created through the <CODE>PortletResponse</CODE>
 * for a specific portlet mode. Then additional parameter can be
 * added to the URI. The complete URI can be converted to a string
 * which is ready for embedding into markup.
 * 
 * <P>
 * On top of the parameters, it is possible to add actions to a
 * portlet URI. Actions are portlet-specific activities that need to
 * be performed as result of the incoming request, but before the
 * <CODE>service()</CODE> method of the portlet is called. For example,
 * the PERSONALIZE mode of the portlet is likely to have a "Save"
 * button at the end of its dialog. The "Save" button has to bring
 * the user back to the DEFAULT mode of the portlet, but to save the
 * personalized portlet data, the portlet needs to be able to process
 * the posted data bfore the next markup is generated. This can be
 * achieved by adding a "Save" action to the URI that represents the
 * "Save" button. The respective listener is attached the respective
 * action listener to the portlet response. This listener will be
 * called when the next request comes and one of the portlet URIs
 * where the reason for the request. If more than one URI were part
 * of the response, the listener need to the check the action content.
 * This depends on the definition of the actual action which is the
 * responsibility of the portlet developer.
 * </P>
 * 
 * @author <A HREF="mailto:tboehme@us.ibm.com">Thomas F. Boehme</A>
 */
public interface PortletURI
{
    /**
     ** Adds the given parameter to this URI. A portlet container
     ** may wish to prefix the attribute names internally, to preserve
     ** a unique namespace for the portlet.
     **
     ** @param   name
     **          the parameter name
     ** @param   value
     **          the parameter value
     **/

    public void addParameter (String name, String value);

    /**
     * Adds the given action to this URI. The action is a
     * portlet-defined implementation of the portlet action interface.
     * It can carry any information. How the information is recovered
     * should the next request be for this URI is at the discretion of
     * the portlet container.
     * 
     * <P>
     * Unless an action listener is registered in the portlet descriptor
     * this action will not be delivered.
     * </P>
     * 
     * @param action
     *               the portlet action
     */
    public void addAction (PortletAction action);

    /**
     ** Returns the complete URI as a string.
     ** The string is ready to be embedded in markup.
     **
     ** <P>
     ** Once the string has been created, adding more parameters
     ** or other listeners will not modify the string. You have to
     ** call this method again, to create an updated string.
     **
     ** @return   the encoded URI as a string
     **/

    public String toString ();
}