/*
 * Copyright 2000-2004 The Apache Software Foundation.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.jetspeed.services.forward;

import java.util.Collection;
import java.util.Map;
import java.util.Iterator;

// Junit imports
import junit.framework.Test;
import junit.framework.TestSuite;


import org.apache.jetspeed.test.HeadlessBaseTest;
import org.apache.jetspeed.util.ServiceUtil;

import org.apache.jetspeed.services.forward.configuration.Forward;
import org.apache.jetspeed.services.forward.configuration.PortletForward;
import org.apache.jetspeed.services.forward.configuration.Page;
import org.apache.jetspeed.services.forward.configuration.Pane;
import org.apache.jetspeed.services.forward.configuration.Portlet;
import org.apache.jetspeed.services.forward.configuration.QueryParam;

/**
 * Test Forward service basics.
 *
 * @author <a href="mailto:taylor@apache.org">David Sean Taylor</a>
 * @version $Id: TestForwardService.java,v 1.1 2004/04/07 22:02:42 jford Exp $
 */

public class TestForwardService extends HeadlessBaseTest
{
    /**
     * Defines the testcase name for JUnit.
     *
     * @param name the testcase's name.
     */
    public TestForwardService( String name ) {
        super( name );
    }

    /**
     * Start the tests.
     *
     * @param args the arguments. Not used
     */
    public static void main(String args[]) {
        junit.awtui.TestRunner.main( new String[] { TestForwardService.class.getName() } );
    }

    public void setup() {
        System.out.println("Setup: Testing TestForwardService");
     }

    public static Test suite()
    {
        // All methods starting with "test" will be executed in the test suite.
        return new TestSuite( TestForwardService.class );
    }


      ///////////////////////////////////////////////////////////////////////////

    public void testConfiguration() throws Exception
    {
        try
        {
            System.out.println("Running TestForwardService");
            ForwardService fs = (ForwardService)ServiceUtil.getServiceByName("ForwardService");
            assertNotNull(fs);
            Collection forwards = fs.getForwards();
            Iterator it = forwards.iterator();
            while (it.hasNext())
            {
                System.out.println("-------------------------------------------");

                Forward forward = (Forward)it.next();
                System.out.println("forward = " + forward.getName());
                Page page = forward.getPage();
                Pane pane = forward.getPane();
                Portlet portlet = forward.getPortlet();
                if (page != null)
                {
                    System.out.println("page = " + page.getName() + ", user = " + page.getUser());
                }
                if (pane != null)
                {
                    System.out.println("pane = " + pane.getId());
                }
                if (portlet != null)
                {
                    System.out.println("portlet = " + portlet.getId() + ", action = " + portlet.getAction());
                }
                printQueryParams(forward.getQueryParams());
            }
            Collection pfs = fs.getPortletForwards();
            it = pfs.iterator();
            while (it.hasNext())
            {
                System.out.println("-------------------------------------------");

                PortletForward pf = (PortletForward)it.next();
                System.out.println("PF: portlet = " + pf.getPortlet() + ", forward = " + pf.getForward() + ", target = " + pf.getTarget());
                printQueryParams(pf.getQueryParams());
            }

            System.out.println("End Run TestForwardService");
        }
        catch (Throwable t)
        {
            t.printStackTrace();
        }
    }

    private void printQueryParams(Map qparams)
    {
        Iterator it = qparams.values().iterator();
        while (it.hasNext())
        {
            QueryParam qp = (QueryParam)it.next();
            System.out.println("QP: name = " + qp.getName() + ", value = " + qp.getValue());
        }

    }

        
}
