/*
 * Copyright(C) 2010 avanza Co.,Ltd. All rights reserved.
 * http://www.avnz.co.jp/
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

package com.aimluck.eip.enquete;

import java.util.Date;

import com.aimluck.commons.field.ALDateTimeField;
import com.aimluck.commons.field.ALNumberField;
import com.aimluck.commons.field.ALStringField;
import com.aimluck.eip.common.ALData;
import com.aimluck.eip.util.ALCommonUtils;
import com.aimluck.eip.util.ALEipUtils;

/**
 * EnqueteのResultDataです。 <BR>
 * 
 */
public class EnqueteResultData implements ALData {

  /** Enquete ID */
  private ALNumberField enquete_id;

  /** 作成ユーザーID */
  private ALNumberField creater_id;
  
  /** アンケート名 */
  private ALStringField name;

  /** コメント */
  private ALStringField comment;

  /** 項目表示有無 */
  private ALStringField item_num_status;

  /** 作成日 */
  private ALStringField create_date;

  /** 更新日 */
  private ALStringField update_date;

  /** 公開・締切状態 */
  private ALStringField public_status;
  
  /** 締切日時 */
  private ALDateTimeField deadline_date;
  
  /** 締切方法 */
  private ALStringField deadline_method;

  
  /** 回答ユーザーID */
  private ALNumberField answer_id;
  
  private ALNumberField choiceItemToEnquete;
  
  //EnqueteItemテーブルの値を取得する
  /** 項目番号 */
  private ALNumberField item_number;

  /** 項目タイトル */
  private ALStringField[] item_title;
  
  /** 選択項目数 */
  private ALNumberField choice_item_num;
  
  /** アンケート作成者名 */
  private ALStringField creater_name;
  /**
   * 
   * @see com.aimluck.eip.common.ALData#initField()
   */
  public void initField() {
    enquete_id = new ALNumberField();
    creater_id = new ALNumberField();
    name = new ALStringField();
    comment = new ALStringField();
    comment.setTrim(false);
    item_num_status = new ALStringField();
    create_date = new ALStringField();
    update_date = new ALStringField();
    public_status = new ALStringField();

    deadline_date = new ALDateTimeField();
    deadline_method = new ALStringField();

    answer_id = new ALNumberField();
    choiceItemToEnquete = new ALNumberField();
    item_number = new ALNumberField();
    item_title = new ALStringField[100];

    choice_item_num = new ALNumberField();
    
    creater_name = new ALStringField();
  }

  /**
   * @return
   */
  
  public ALNumberField getEnqueteId() {
    return enquete_id;
  }

  /**
   * @return
   */
  public String getName() {
    return ALCommonUtils.replaceToAutoCR(name.toString());
  }

  /**
   * @param i
   */
  public void setEnqueteId(long i) {
    enquete_id.setValue(i);
  }

  /**
   * @param string
   */
  public void setName(String string) {
    name.setValue(string);
  }

  /**
   * @return
   */
  public String getComment() {
    return ALEipUtils.getMessageList(comment.getValue());
  }

  /**
   * @param string
   */
  public void setComment(String string) {
    comment.setValue(string);
  }


  /**
   * @return
   */
  public ALStringField getCreateDate() {
    return create_date;
  }

  /**
   * @return
   */
  public ALStringField getUpdateDate() {
    return update_date;
  }

  /**
   * @param string
   */
  public void setCreateDate(String string) {
    create_date.setValue(string);
  }

  /**
   * @param string
   */
  public void setUpdateDate(String string) {
    update_date.setValue(string);
  }
  
  public ALStringField getItemNumStatus(){
    return item_num_status;
  }
  public void setItemNumStatus(String string){
    item_num_status.setValue(string);
  }
  public ALStringField getPublicStatus(){
    return public_status;
  }
  public void setPublicStatus(String string){
    public_status.setValue(string);
  }
  public ALDateTimeField getDeadlineDate(){
    return deadline_date;
  }
  public void setDeadlineDate(Date date){
    deadline_date.setValue(date);
  }
  public ALNumberField getCreaterId() {
    return creater_id;
  }
  public void setCreaterId(long i) {
    creater_id.setValue(i);
  }
  public ALNumberField getAnswerId() {
    return answer_id;
  }
  public void setAnswerId(long i) {
    answer_id.setValue(i);
  }
  
  public ALNumberField getChoiceItemToEnquete() {
    return choiceItemToEnquete;
  }
  public void setChoiceItemToEnquete(long i) {
    choiceItemToEnquete.setValue(i);
  }
  public ALNumberField getItemNumber() {
    return item_number;
  }
  public void setItemNumber(long i) {
    item_number.setValue(i);
  }  
  public ALStringField[] getItemTitle(){
    return item_title;
  }
  public ALNumberField getChoiceItemNum() {
    return choice_item_num;
  }
  public void setChoiceItemNum(long i) {
    choice_item_num.setValue(i);
  }

  public void setItemTitle(ALStringField[] item_title) {
    this.item_title = item_title;
  }

  public ALStringField getDeadlineMethod() {
    return deadline_method;
  }

  public void setDeadlineMethod(String string) {
    deadline_method.setValue(string);
  }

  public ALStringField getCreaterName() {
    return creater_name;
  }

  public void setCreaterName(ALStringField creater_name) {
    this.creater_name = creater_name;
  }  
  
}
