/*
 * Copyright(C) 2010 avanza Co.,Ltd. All rights reserved.
 * http://www.avnz.co.jp/
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */


package com.aimluck.eip.enquete;

import java.util.ArrayList;

import org.apache.cayenne.access.DataContext;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

import com.aimluck.commons.field.ALStringField;
import com.aimluck.eip.cayenne.om.portlet.AvzTEnquete;
import com.aimluck.eip.common.ALAbstractFormData;
import com.aimluck.eip.common.ALDBErrorException;
import com.aimluck.eip.common.ALPageNotFoundException;
import com.aimluck.eip.enquete.util.EnqueteUtils;
import com.aimluck.eip.modules.actions.common.ALAction;
import com.aimluck.eip.orm.DatabaseOrmService;
import com.aimluck.eip.services.eventlog.ALEventlogConstants;
import com.aimluck.eip.services.eventlog.ALEventlogFactoryService;

/**
 * Enqueteのフォームデータを管理するクラスです。 <BR>
 * 
 */
public class EnqueteSetDeadlineFormData extends ALAbstractFormData {

  /** logger */
  private static final JetspeedLogger logger = JetspeedLogFactoryService
      .getLogger(EnqueteFormData.class.getName());

  
  private DataContext dataContext;

  /** アンケート名 */
  private ALStringField name;

  /** 公開・締切状態 */
  private ALStringField status;
  
  /** 公開締切状態（未公開） */
  public static final String PUBLIC_STATUS_BEFORE = "0";

  /** 公開締切状態（実施中） */
  public static final String PUBLIC_STATUS_PRACTICE = "1";

  /** 公開締切状態（締切済） */
  public static final String PUBLIC_STATUS_AFTER = "2";
  
  /** 締切方法（手動締切） */
  public static final String DEADLINE_METHOD_HANDOPERATED = "0";
  
  /** 締切方法（自動締切） */
  public static final String DEADLINE_METHOD_AUTO = "1";
  /**
   * init
   * 
   * @param action
   * @param rundata
   * @param context
   * @see com.aimluck.eip.common.ALAbstractFormData#init(com.aimluck.eip.modules.actions.common.ALAction,
   *      org.apache.turbine.util.RunData, org.apache.velocity.context.Context)
   */
  public void init(ALAction action, RunData rundata, Context context)
      throws ALPageNotFoundException, ALDBErrorException {
    
    super.init(action, rundata, context);
    
    dataContext = DatabaseOrmService.getInstance().getDataContext();

    /**下記のコメントアウトのようにアクセスコントロールを追加する場合は
     * com.aimluck.eip.services.accessctl.ALAccessControlConstantsに
     * アクセスコントロール用の定数を追加してください。
     * (例)  public static final String POERTLET_FEATURE_ENQUETE_ENQUETE_OTHER = "enquete_enquete_other";
    */
  
    //aclPortletFeature = ALAccessControlConstants.POERTLET_FEATURE_ENQUETE_ENQUETE_SELF;
  
  }
  
  /**
   * 各フィールドを初期化します。 <BR>
   * 
   * @see com.aimluck.eip.common.ALData#initField()
   */
  
  public void initField() {

    // アンケート名
    name = new ALStringField();
    name.setFieldName("アンケート名");

    // 公開・締切状態
    status = new ALStringField();
    status.setFieldName("公開・締切状態");
  }
  
  
  /**
   * アンケートの各フィールドに対する制約条件を設定します。 <BR>
   * 
   * @see com.aimluck.eip.common.ALAbstractFormData#setValidator()
   */
  protected void setValidator() {
    
  }

 
  /**
   * 
   * @param rundata
   * @param context
   * @param msgList
   * @return
   * @see com.aimluck.eip.common.ALAbstractFormData#setFormData(org.apache.turbine.util.RunData,
   *      org.apache.velocity.context.Context, java.util.ArrayList)
   */
  protected boolean setFormData(RunData rundata, Context context,
      ArrayList msgList) throws ALPageNotFoundException, ALDBErrorException {
    boolean res = super.setFormData(rundata, context, msgList);
    
    return res;
  }
  
  /**
   * アンケートのフォームに入力されたデータの妥当性検証を行います。 <BR>
   * 
   * @param msgList
   * @return TRUE 成功 FALSE 失敗
   * @see com.aimluck.eip.common.ALAbstractFormData#validate(java.util.ArrayList)
   */
  protected boolean validate(ArrayList msgList) {
    return (msgList.size() == 0);
  }
 
 
  /**
   * アンケートをデータベースから読み出します。 <BR>
   * 
   * @param rundata
   * @param context
   * @param msgList
   * @return TRUE 成功 FALSE 失敗
   * @see com.aimluck.eip.common.ALAbstractFormData#loadFormData(org.apache.turbine.util.RunData,
   *      org.apache.velocity.context.Context)
   */
  protected boolean loadFormData(RunData rundata, Context context,
      ArrayList msgList) {

    try {
      // // オブジェクトモデルを取得
      AvzTEnquete enquete = EnqueteUtils.getAvzTEnquete(rundata, context);
      if (enquete == null){
        return false;
      }
      
      // アンケート名
      name.setValue(enquete.getName());
      status.setValue(enquete.getPublicStatus());
      
       
    } catch (Exception ex) {
      dataContext.rollbackChanges();
      logger.error("Exception", ex);
      return false;
    }
    return true;
  }

  /**
   * Enqueteをデータベースに格納します。 <BR>
   * 
   * @param rundata
   * @param context
   * @param msgList
   * @return TRUE 成功 FALSE 失敗
   * @see com.aimluck.eip.common.ALAbstractFormData#insertFormData(org.apache.turbine.util.RunData,
   *      org.apache.velocity.context.Context, java.util.ArrayList)
   */
  protected boolean insertFormData(RunData rundata, Context context,
      ArrayList msgList) {
 
    return true;
  }

  /**
   * データベースに格納されているEnqueteを更新します。 <BR>
   * 
   * @param rundata
   * @param context
   * @param msgList
   * @return TRUE 成功 FALSE 失敗
   * @see com.aimluck.eip.common.ALAbstractFormData#updateFormData(org.apache.turbine.util.RunData,
   *      org.apache.velocity.context.Context, java.util.ArrayList)
   */
  protected boolean updateFormData(RunData rundata, Context context,
      ArrayList msgList) {
    try {
      // オブジェクトモデルを取得
      AvzTEnquete enquete = EnqueteUtils.getAvzTEnquete(rundata, context);
      if (enquete == null)
        return false;
      
      String public_flag =enquete.getPublicStatus();
      
      if(public_flag.equals(PUBLIC_STATUS_PRACTICE)){
        enquete.setPublicStatus(PUBLIC_STATUS_AFTER);
      }else if(public_flag.equals(PUBLIC_STATUS_AFTER)){
        enquete.setPublicStatus(PUBLIC_STATUS_PRACTICE);
      }
      enquete.setDeadlineMethod(DEADLINE_METHOD_HANDOPERATED);
      enquete.setDeadlineDate(EnqueteUtils.getEmptyDate());

      dataContext.commitChanges();


      // イベントログに保存
      ALEventlogFactoryService.getInstance().getEventlogHandler().log(
          enquete.getEnqueteId(), ALEventlogConstants.PORTLET_TYPE_NONE,
          name.getValue());
      
    } catch (Exception ex) {
      dataContext.rollbackChanges();
      logger.error("Exception", ex);
      return false;
    }
    return true;
  }

  /**
   * Enqueteをデータベースから削除します。 <BR>
   * 
   * @param rundata
   * @param context
   * @param msgList
   * @return TRUE 成功 FALSE 失敗
   * @see com.aimluck.eip.common.ALAbstractFormData#deleteFormData(org.apache.turbine.util.RunData,
   *      org.apache.velocity.context.Context)
   */
  protected boolean deleteFormData(RunData rundata, Context context,
      ArrayList msgList) {
  
    return true;
  }

  
  public static JetspeedLogger getLogger() {
    return logger;
  }

  public DataContext getDataContext() {
    return dataContext;
  }
 
  
  /**
   * アンケート名を取得します。 <BR>
   * 
   * @return
   */
  public ALStringField getName() {
    return name;
  }

  /**
   * 公開・締切状態を取得します。 <BR>
   * 
   * @return
   */
  public ALStringField getStatus() {
    return status;
  }


}
