/*
 * Copyright(C) 2010 avanza Co.,Ltd. All rights reserved.
 * http://www.avnz.co.jp/
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

package com.aimluck.eip.enquete.util;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;

import org.apache.cayenne.access.DataContext;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.cayenne.query.Ordering;
import org.apache.cayenne.query.SelectQuery;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

import com.aimluck.commons.field.ALStringField;
import com.aimluck.eip.cayenne.om.portlet.AvzTEnquete;
import com.aimluck.eip.cayenne.om.portlet.AvzTEnqueteChoiceItem;
import com.aimluck.eip.cayenne.om.portlet.AvzTEnqueteItem;
import com.aimluck.eip.common.ALEipConstants;
import com.aimluck.eip.common.ALEipUser;
import com.aimluck.eip.common.ALPageNotFoundException;
import com.aimluck.eip.enquete.EnqueteChoiceItemRecordData;
import com.aimluck.eip.orm.DatabaseOrmService;
import com.aimluck.eip.util.ALEipUtils;


/**
 * Enqueteのユーティリティクラスです。 <BR>
 * 
 */
public class EnqueteUtils {

  /** logger */
  private static final JetspeedLogger logger = JetspeedLogFactoryService
      .getLogger(EnqueteUtils.class.getName());

  
  public static final String TARGET_GROUP_NAME = "target_group_name";
  
  /** 公開締切状態（未公開） */
  public static final String PUBLIC_STATUS_BEFORE = "0";

  /** 公開締切状態（実施中） */
  public static final String PUBLIC_STATUS_PRACTICE = "1";

  /** 公開締切状態（締切済） */
  public static final String PUBLIC_STATUS_AFTER = "2";
  
  /** 締切方法（手動締切） */
  public static final String DEADLINE_METHOD_HANDOPERATED = "0";
  
  /** 締切方法（自動締切） */
  public static final String DEADLINE_METHOD_AUTO = "1";
  
  /** 回答状態（未回答） */
  public static final String RESPONSE_STATUS_BEFORE = "0";
  
  /** 回答状態（回答済） */
  public static final String RESPONSE_STATUS_AFTER = "1";
  
  /** 選択肢状態（未選択） */
  public static final String STATUS_NO_SELECT = "0";
  
  /** 選択肢状態（選択） */
  public static final String STATUS_SELECT = "1";
  
  /**
   * Enquete オブジェクトモデルを取得します。 <BR>
   * 
   * @param rundata
   * @param context
   * @return
   */
  public static AvzTEnquete getAvzTEnquete(RunData rundata, Context context)
      throws ALPageNotFoundException {
    String enqueteid = ALEipUtils.getTemp(rundata, context,
        ALEipConstants.ENTITY_ID);
    int uid = ALEipUtils.getUserId(rundata);
    try {
      if (enqueteid == null || Integer.valueOf(enqueteid) == null) {
        // Enquete IDが空の場合
        logger.debug("[Enquete] Empty ID...");
        return null;
      }

      DataContext dataContext = DatabaseOrmService.getInstance()
          .getDataContext();

      SelectQuery query = new SelectQuery(AvzTEnquete.class);
      Expression exp = ExpressionFactory.matchDbExp(AvzTEnquete.ENQUETE_ID_PK_COLUMN , enqueteid);
      query.setQualifier(exp);
      List enquetes = dataContext.performQuery(query);
      
      if (enquetes == null || enquetes.size() == 0) {
        // 指定したEnquete IDのレコードが見つからない場合
        logger.debug("[Enquete] Not found ID...");
        return null;
      }

      return (AvzTEnquete) enquetes.get(0);
      
    } catch (Exception ex) {
      logger.error("Exception", ex);
      return null;
    }
  }
  
  /**
   * 
   * @param date
   * @return
   */
  public static boolean isEmptyDate(Date date) {
    if (date == null)
      return false;
    return date.getYear() == 8099;
//    Calendar.get(Calendar.YEAR)-1900
  }
  
  
  public static Date getEmptyDate() {
    Calendar cal = Calendar.getInstance();
    cal.set(9999, 11, 31);
    return cal.getTime();
  }
  
  public static ALStringField getChoiceItem(RunData rundata, Context context, int item_id ,List users)
  throws ALPageNotFoundException {
    
    try {

      DataContext dataContext = DatabaseOrmService.getInstance().getDataContext();
      
      SelectQuery choicequery = new SelectQuery(AvzTEnqueteChoiceItem.class);

      Expression choiceexp = ExpressionFactory.matchDbExp(
          AvzTEnqueteChoiceItem.AVZ_TENQUETE_ITEM_PROPERTY + "." +
          AvzTEnqueteItem.ITEM_ID_PK_COLUMN, item_id);
      Expression choiceexp2 = ExpressionFactory.matchExp(
          AvzTEnqueteChoiceItem.ANSWER_ID_PROPERTY, users.get(0));
        
      choicequery.setQualifier(choiceexp.andExp(choiceexp2));
      choicequery.setDistinct(true);
        
      List choicelist = dataContext.performQuery(choicequery);
      
      String choiceitemname = null;
      ALStringField choiceitem = new ALStringField();

      
      
      for (int k = 0 ; k < choicelist.size(); k++ ) {
        
        AvzTEnqueteChoiceItem choice = (AvzTEnqueteChoiceItem) choicelist.get(k);
        
        if(k == 0){
            choiceitemname = choice.getChoiceItemTitle();
            
        }else if(k > 0 && k < choicelist.size()-1){
            choiceitemname = choiceitemname + " , " + choice.getChoiceItemTitle();
          
        }else if(k == choicelist.size()-1){
            choiceitemname = choiceitemname + " , " + choice.getChoiceItemTitle();

        }

      }
      choiceitem.setValue(choiceitemname);
      return choiceitem;


    } catch (Exception ex) {
      logger.error("Exception", ex);
      return null;
      
    }


  }

  public static String insertChoiceItem(RunData rundata, Context context , ArrayList msgList ,
      DataContext dataContext ,ALStringField[] choice_item_title, int j,AvzTEnquete enquete, 
      AvzTEnqueteItem enqueteitem, List memberList){
    
    String choiceItem = rundata.getParameters().getString("choice_item_title[" +j+ "]");
    String choiceItemToken[] = choiceItem.split(",");

    int choiceItemSum = 0;
    for (int k = 0; k < memberList.size(); k++){
      
      for (int l = 0; l < choiceItemToken.length; l++) {
      
        // 新規オブジェクトモデル
        AvzTEnqueteChoiceItem choiceitem = (AvzTEnqueteChoiceItem) dataContext
            .createAndRegisterNewObject(AvzTEnqueteChoiceItem.class);
        
        choiceitem.setAvzTEnquete(enquete);
        choiceitem.setAvzTEnqueteItem(enqueteitem);
        //回答ユーザー
        int memberId = (int) ((ALEipUser) memberList.get(k)).getUserId()
        .getValue();
        choiceitem.setAnswerId(memberId);
        //項目番号
        choiceitem.setItemNumber(j);
        //選択項目番号
        choiceitem.setChoiceItemNumber(l+1);
        //選択肢名
        ALStringField splitItem = new ALStringField();
        splitItem.setValue(choiceItemToken[l]);
        choiceitem.setChoiceItemTitle(splitItem.getValue());

        //状態(選択、未選択) ※作成時は未選択で登録
        choiceitem.setStatus(STATUS_NO_SELECT);
        //回答状態 ※作成時は未回答で登録
        choiceitem.setResponseStatus(RESPONSE_STATUS_BEFORE);
                
        //選択肢の項目数
        choiceItemSum = l+1;
      }
    }

    EnqueteUtils.getItemSum(enqueteitem, choiceItemSum, dataContext);
    return null;
  }
  
  
  public static List updateChoiceItem(RunData rundata, Context context , ArrayList msgList ,
      DataContext dataContext ,ALStringField[] choice_item_title, int m,AvzTEnquete enquete, 
      AvzTEnqueteItem enqueteitem, List memberList){
    
    int itemNum = m+1;
    String choiceItem = rundata.getParameters().getString("choice_item_title[" +itemNum+ "]");
    String choiceItemToken[] = choiceItem.split(",");
    
    int choiceItemSum = 0;

    for (int k = 0; k < memberList.size(); k++){
      
      for (int l = 0; l < choiceItemToken.length; l++) {
      
        // 新規オブジェクトモデル
        AvzTEnqueteChoiceItem choiceitem = (AvzTEnqueteChoiceItem) dataContext
            .createAndRegisterNewObject(AvzTEnqueteChoiceItem.class);
        
        choiceitem.setAvzTEnquete(enquete);
        choiceitem.setAvzTEnqueteItem(enqueteitem);
        //回答ユーザー
        int memberId = (int) ((ALEipUser) memberList.get(k)).getUserId()
        .getValue();
        choiceitem.setAnswerId(memberId);
        //項目番号
        choiceitem.setItemNumber(itemNum);
        //選択項目番号
        choiceitem.setChoiceItemNumber(l+1);
        //選択肢名
        ALStringField splitItem = new ALStringField();
        splitItem.setValue(choiceItemToken[l]);
        choiceitem.setChoiceItemTitle(splitItem.getValue());
        //状態(選択、未選択) ※作成時は未選択で登録
        choiceitem.setStatus(STATUS_NO_SELECT);
        //回答状態 ※作成時は未回答で登録
        choiceitem.setResponseStatus(RESPONSE_STATUS_BEFORE);
                
        //選択肢の項目数
        choiceItemSum = l+1;
      }
    }

    EnqueteUtils.getItemSum(enqueteitem, choiceItemSum, dataContext);
    return memberList;
  }
  
  
  
  public static void getItemSum(AvzTEnqueteItem enqueteitem, int choiceItemSum, DataContext dataContext){
    enqueteitem.setChoiceItemNum(choiceItemSum);
  }
  
  
  
  
  public static ArrayList getAnswerChoiceItem(RunData rundata, Context context,
      int item_id, int loginuserid)
  throws ALPageNotFoundException {
    
    try {

      DataContext dataContext = DatabaseOrmService.getInstance().getDataContext();
      
      SelectQuery choicequery = new SelectQuery(AvzTEnqueteChoiceItem.class);

      Expression choiceexp = ExpressionFactory.matchDbExp(
          AvzTEnqueteChoiceItem.AVZ_TENQUETE_ITEM_PROPERTY + "." +
          AvzTEnqueteItem.ITEM_ID_PK_COLUMN, item_id);
      Expression choiceexp2 = ExpressionFactory.matchExp(
          AvzTEnqueteChoiceItem.ANSWER_ID_PROPERTY, loginuserid);
        
      choicequery.setQualifier(choiceexp.andExp(choiceexp2));
      choicequery.setDistinct(true);
        
      List choicelist = dataContext.performQuery(choicequery);
      
      ArrayList choiceresults = new ArrayList();

      for (Object r : choicelist) {
        AvzTEnqueteChoiceItem choiceitem = (AvzTEnqueteChoiceItem)r;
        EnqueteChoiceItemRecordData c = new EnqueteChoiceItemRecordData();
        ALStringField record = new ALStringField();
        record.setValue(choiceitem.getChoiceItemTitle());
        c.setChoiceItemTitle(record);
        c.setSelectStatus(choiceitem.getStatus());
        c.setResponse(choiceitem.getResponseStatus());
        
        choiceresults.add(c);

      }
    
      return choiceresults;

    
    } catch (Exception ex) {
      logger.error("Exception", ex);
      return null;
      
    }

  }
  
  public static ArrayList getPracticePreview(RunData rundata, Context context,
      int item_id, int someAnswer)
  throws ALPageNotFoundException {
    
    try {

      DataContext dataContext = DatabaseOrmService.getInstance().getDataContext();
      
      SelectQuery choicequery = new SelectQuery(AvzTEnqueteChoiceItem.class);

      Expression choiceexp = ExpressionFactory.matchDbExp(
          AvzTEnqueteChoiceItem.AVZ_TENQUETE_ITEM_PROPERTY + "." +
          AvzTEnqueteItem.ITEM_ID_PK_COLUMN, item_id);
      Expression choiceexp2 = ExpressionFactory.matchExp(
          AvzTEnqueteChoiceItem.ANSWER_ID_PROPERTY, someAnswer);
        
      choicequery.setQualifier(choiceexp.andExp(choiceexp2));
      choicequery.setDistinct(true);
        
      List choicelist = dataContext.performQuery(choicequery);
      
      ArrayList choiceresults = new ArrayList();

      for (Object r : choicelist) {
        AvzTEnqueteChoiceItem choiceitem = (AvzTEnqueteChoiceItem)r;
        EnqueteChoiceItemRecordData c = new EnqueteChoiceItemRecordData();
        ALStringField record = new ALStringField();
        record.setValue(choiceitem.getChoiceItemTitle());
        c.setChoiceItemTitle(record);
        c.setSelectStatus(choiceitem.getStatus());
        c.setResponse(choiceitem.getResponseStatus());
        
        choiceresults.add(c);

      }
    
      return choiceresults;

    
    } catch (Exception ex) {
      logger.error("Exception", ex);
      return null;
      
    }

  }
  
  public static ArrayList getSummaryChoiceItem(RunData rundata, Context context,
      int item_id, int someAnswer, int i, AvzTEnquete enquete)
  throws ALPageNotFoundException {
    
    try {

      //項目番号
      int itemNum = i+1;
      
      
      DataContext dataContext = DatabaseOrmService.getInstance().getDataContext();
      
      SelectQuery choicequery = new SelectQuery(AvzTEnqueteChoiceItem.class);
      
      Expression choiceexp = ExpressionFactory.matchDbExp(
          AvzTEnqueteChoiceItem.AVZ_TENQUETE_ITEM_PROPERTY + "." +
          AvzTEnqueteItem.ITEM_ID_PK_COLUMN, item_id);
        
      Expression choiceexp2 = ExpressionFactory.matchExp(
          AvzTEnqueteChoiceItem.ANSWER_ID_PROPERTY, someAnswer);
      
      choicequery.setQualifier(choiceexp.andExp(choiceexp2));
      choicequery.setDistinct(true);
      choicequery.addOrdering("choiceItemNumber" , Ordering.ASC);
        
      List choicelist = dataContext.performQuery(choicequery);
      
      ArrayList choiceresults = new ArrayList();

      for (int j = 0; j < choicelist.size(); j++) {
        AvzTEnqueteChoiceItem choiceitem = (AvzTEnqueteChoiceItem)choicelist.get(j);
        EnqueteChoiceItemRecordData c = new EnqueteChoiceItemRecordData();
        ALStringField record = new ALStringField();
        record.setValue(choiceitem.getChoiceItemTitle());
        c.setChoiceItemTitle(record);
        c.setChoiceSelected(getSelectedSum(item_id , j));
        int selected = c.getChoiceSelected();
        c.setChoicePercnt(getTotalPercnt(item_id, selected, enquete));
        
        choiceresults.add(c);

      }

      return choiceresults;

    } catch (Exception ex) {
      logger.error("Exception", ex);
      return null;
      
    }

  }
  
  
  
  public static int getSelectedSum(int item_id, int j){
    
    int selectedSum = 0;

    //選択肢番号
    int choiceNum = j+1;
    DataContext dataContext = DatabaseOrmService.getInstance().getDataContext();
    
    SelectQuery choicequery = new SelectQuery(AvzTEnqueteChoiceItem.class);

    Expression choiceexp = ExpressionFactory.matchDbExp(
        AvzTEnqueteChoiceItem.AVZ_TENQUETE_ITEM_PROPERTY + "." +
        AvzTEnqueteItem.ITEM_ID_PK_COLUMN, item_id);
    Expression choiceexp2 = ExpressionFactory.matchExp(
        AvzTEnqueteChoiceItem.STATUS_PROPERTY, STATUS_SELECT);
    Expression choiceexp3 = ExpressionFactory.matchExp(
        AvzTEnqueteChoiceItem.CHOICE_ITEM_NUMBER_PROPERTY, choiceNum);
    
    choicequery.setQualifier(choiceexp.andExp(choiceexp2).andExp(choiceexp3));
    
    List choicelist = dataContext.performQuery(choicequery);
    
    selectedSum = choicelist.size();
    
    
    return selectedSum;
  }
  
  
  
  public static double getTotalPercnt(int item_id, int selected, AvzTEnquete enquete){
    
    double totalPercnt = 0.0;
    //選択された選択肢の総数をdouble型に
    double selectedSum = (double)selected;
    
    //同じ項目IDを持つ選択肢の総数を取得する
    DataContext dataContext = DatabaseOrmService.getInstance().getDataContext();
    
    SelectQuery choicequery = new SelectQuery(AvzTEnqueteChoiceItem.class);

    Expression choiceexp = ExpressionFactory.matchDbExp(
        AvzTEnqueteChoiceItem.AVZ_TENQUETE_ITEM_PROPERTY + "." +
        AvzTEnqueteItem.ITEM_ID_PK_COLUMN, item_id);
    Expression choiceexp2 = ExpressionFactory.matchExp(
        AvzTEnqueteChoiceItem.ENQUETE_ID_PROPERTY, enquete.getEnqueteId());

    choicequery.setQualifier(choiceexp.andExp(choiceexp2));
    List choicelist = dataContext.performQuery(choicequery);

    //項目ID毎の総数
    double Sum = choicelist.size();
    
    //項目毎の選択肢数を取得
    SelectQuery itemquery = new SelectQuery(AvzTEnqueteItem.class);

    Expression itemexp = ExpressionFactory.matchDbExp(
        AvzTEnqueteItem.ITEM_ID_PK_COLUMN, item_id);

    itemquery.setQualifier(itemexp);
    List itemlist = dataContext.performQuery(itemquery);
    
    double choiceSum = 0.0;
    for(int i = 0; i < itemlist.size(); i++){
      AvzTEnqueteItem item = (AvzTEnqueteItem)itemlist.get(i);
      item.getChoiceItemNum();
      //項目毎の選択肢数
      choiceSum = item.getChoiceItemNum();
    }
    
    //分母になる数
    //項目÷選択肢数で回答メンバーの総数を取得
    double memberSum = Sum / choiceSum;

    totalPercnt = selectedSum / memberSum * 100;
   
    //小数点第二位以下切捨て  
    BigDecimal bi = new BigDecimal(String.valueOf(totalPercnt));
    totalPercnt = bi.setScale(1,BigDecimal.ROUND_DOWN).doubleValue();

    return totalPercnt;

  }

  
  
  public static List setPublicStatus(DataContext dataContext, List list){
    
    //　現在時刻を取得
    Date now = Calendar.getInstance().getTime();
    
    for(int i = 0; i < list.size(); i++){
      
      AvzTEnquete enquete = (AvzTEnquete)list.get(i);
      
      if(enquete.getDeadlineMethod().equals(DEADLINE_METHOD_HANDOPERATED)){
        continue;
      }else{
        
        //締切時刻を取得する
        Date date = enquete.getDeadlineDate();
        
        //締切時刻が現在時刻より前だった場合締切にする
        if(date.before(now)){
          enquete.setPublicStatus(PUBLIC_STATUS_AFTER);
          enquete.setDeadlineDate(getEmptyDate());
          dataContext.commitChanges();

        }else{
          continue;
    
        }
      }
    }
    return list;    
  }

}
