<%--
Copyright 2004 The Apache Software Foundation

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
--%>
<%@ page language="java"
         import="java.util.Enumeration"
         session="false"
%>
<%@ taglib uri='/WEB-INF/templates/jsp/tld/template.tld' prefix='jetspeed' %>
    <html>
<!--
  Copyright (c) 2001 The Apache Software Foundation.  All rights 
  reserved.
-->

<!--
 A JSP portlet example that displays Jetspeed TagLib and servlet request
 data. 

 @author <a href="mailto:paulsp@apache.org">Paul Spencer</a>
-->
  <body>
    <center><h1><jetspeed:l10n key="JSP1_1ANDJETSPEEDTAGLIB_JETSPEED_TAG_LIBRARY_JSP"/></h1></center>
    <center><h2><jetspeed:l10n key="JSP1_1ANDJETSPEEDTAGLIB_JETSPEED_INFO_JSP"/></h2></center>
    <table>
      <tr>
        <th><jetspeed:l10n key="JSP1_1ANDJETSPEEDTAGLIB_REQUESTEDINFO_JSP"/></th>
        <th><jetspeed:l10n key="JSP1_1ANDJETSPEEDTAGLIB_RETURNED_VALUE_JSP"/></th>
      </tr>
      <tr>
        <td><jetspeed:l10n key="JSP1_1ANDJETSPEEDTAGLIB_EMAIL_JSP"/></td>
        <td><jetspeed:info requestedInfo="Email" /></td>
      </tr>
      <tr>
        <td><jetspeed:l10n key="JSP1_1ANDJETSPEEDTAGLIB_FIRSTNAME_JSP"/></td>
        <td><jetspeed:info requestedInfo="FirstName" /></td>
      </tr>
      <tr>
        <td><jetspeed:l10n key="JSP1_1ANDJETSPEEDTAGLIB_LASTNAME_JSP"/></td>
        <td><jetspeed:info requestedInfo="LastName" /></td>
      </tr>
      <tr>
        <td><jetspeed:l10n key="JSP1_1ANDJETSPEEDTAGLIB_USERNAME_JSP"/></td>
        <td><jetspeed:info requestedInfo="UserName" /></td>
      </tr>
      <tr>
        <td><jetspeed:l10n key="JSP1_1ANDJETSPEEDTAGLIB_SERVERDATE_JSP"/></td>
        <td><jetspeed:info requestedInfo="ServerDate" /></td>
      </tr>
    </table>

    <center><h2><jetspeed:l10n key="JSP1_1ANDJETSPEEDTAGLIB_JETSPEED_URILOOKUP_JSP"/></h2></center>
    <table>
      <tr>
        <th><jetspeed:l10n key="JSP1_1ANDJETSPEEDTAGLIB_TYPE_JSP"/></th>
        <th><jetspeed:l10n key="JSP1_1ANDJETSPEEDTAGLIB_RETURNED_VALUE_JSP"/></th>
      </tr>
      <tr>
        <td><jetspeed:l10n key="JSP1_1ANDJETSPEEDTAGLIB_CUSTOMIZE_JSP"/></td>
        <td><jetspeed:uriLookup type="Customize" /></td>
      </tr>
      <tr>
        <td><jetspeed:l10n key="JSP1_1ANDJETSPEEDTAGLIB_EDITACCOUNT_JSP"/></td>
        <td><jetspeed:uriLookup type="EditAccount" /></td>
      </tr>
      <tr>
        <td><jetspeed:l10n key="JSP1_1ANDJETSPEEDTAGLIB_LOGIN_JSP"/></td>
        <td><jetspeed:uriLookup type="Login" /></td>
      </tr>
      <tr>
        <td><jetspeed:l10n key="JSP1_1ANDJETSPEEDTAGLIB_LOGOUT_JSP"/></td>
        <td><jetspeed:uriLookup type="Logout" /></td>
      </tr>
      <tr>
        <td><jetspeed:l10n key="JSP1_1ANDJETSPEEDTAGLIB_HOME_JSP"/></td>
        <td><jetspeed:uriLookup type="Home" /></td>
      </tr>
    </table>

    <center><h2><jetspeed:l10n key="JSP1_1ANDJETSPEEDTAGLIB_JETSPEED_CONTENTURI_JSP"/></h2></center>
    <table>
      <tr>
        <th><jetspeed:l10n key="JSP1_1ANDJETSPEEDTAGLIB_HREF_JSP"/></th>
        <th><jetspeed:l10n key="JSP1_1ANDJETSPEEDTAGLIB_RETURNED_VALUE_JSP"/></th>
      </tr>
      <tr>
        <td><jetspeed:l10n key="JSP1_1ANDJETSPEEDTAGLIB_APIDOCS_JSP"/></td>
        <td><jetspeed:contentUri href="apidocs/" /></td>
      </tr>
      <tr>
        <td><jetspeed:l10n key="JSP1_1ANDJETSPEEDTAGLIB_DOCS_JSP"/></td>
        <td><jetspeed:contentUri href="docs/" /></td>
      </tr>
      <tr>
        <td><jetspeed:l10n key="JSP1_1ANDJETSPEEDTAGLIB_RSS_JSP"/></td>
        <td><jetspeed:contentUri href="rss/" /></td>
      </tr>
    </table>

    <center><h2><jetspeed:l10n key="JSP1_1ANDJETSPEEDTAGLIB_JETSPEED_LINK_JSP"/></h2></center>
    <table>
      <tr>
        <th><jetspeed:l10n key="JSP1_1ANDJETSPEEDTAGLIB_TEMPLATE_JSP"/></th>
        <th><jetspeed:l10n key="JSP1_1ANDJETSPEEDTAGLIB_ACTION_JSP"/></th>        
        <th><jetspeed:l10n key="JSP1_1ANDJETSPEEDTAGLIB_RETURNED_VALUE_JSP"/></th>
      </tr>
      <tr>
        <td><jetspeed:l10n key="JSP1_1ANDJETSPEEDTAGLIB_LOGIN_JSP"/></td>
        <td><jetspeed:l10n key="JSP1_1ANDJETSPEEDTAGLIB_JLOGOUTUSER_JSP"/></td>        
        <td><jetspeed:link template="Login" action="JLogoutUser"/></td>
      </tr>
      <tr>
        <td><jetspeed:l10n key="JSP1_1ANDJETSPEEDTAGLIB_CHANGEPASSWORD_JSP"/></td>
        <td></td>                
        <td><jetspeed:link template="ChangePassword" /></td>
      </tr>
    </table>

    <center><h2><jetspeed:l10n key="JSP1_1ANDJETSPEEDTAGLIB_JETSPEED_PORTLET_JSP"/></h2></center>
    <table>
      <tr>
        <th><jetspeed:l10n key="JSP1_1ANDJETSPEEDTAGLIB_NAME_JSP"/></th>
        <th><jetspeed:l10n key="JSP1_1ANDJETSPEEDTAGLIB_PSML_JSP"/></th>        
        <th><jetspeed:l10n key="JSP1_1ANDJETSPEEDTAGLIB_RETURNED_VALUE_JSP"/></th>
      </tr>
      <tr>
        <td><jetspeed:l10n key="JSP1_1ANDJETSPEEDTAGLIB_HELLOVELOCITY_JSP"/></td>
        <td><jetspeed:l10n key="JSP1_1ANDJETSPEEDTAGLIB_USER_TURBINE_MEDIA_T_JSP"/></td>        
        <td><jetspeed:portlet name="HelloVelocity" psml="user/turbine/media-type/html/page/default.psml"/></td>
      </tr>
      <tr>
        <td><jetspeed:l10n key="JSP1_1ANDJETSPEEDTAGLIB_JETSPEEDFRAMED_JSP"/><SMALL><p><jetspeed:l10n key="JSP1_1ANDJETSPEEDTAGLIB_YOU_WILL_NEED_JETSP_JSP"/></P></SMALL></td>
        <td>&nbsp;</td>                
        <td><jetspeed:portlet name="JetspeedFramed"/></td>
      </tr>      
    </table>

    <center><h2><jetspeed:l10n key="JSP1_1ANDJETSPEEDTAGLIB_JETSPEED_PORTLETLINK_JSP"/></h2></center>
    <table>
      <tr>
        <th><jetspeed:l10n key="JSP1_1ANDJETSPEEDTAGLIB_NAME_JSP"/></th>
        <th><jetspeed:l10n key="JSP1_1ANDJETSPEEDTAGLIB_PSML_JSP"/></th>        
        <th><jetspeed:l10n key="JSP1_1ANDJETSPEEDTAGLIB_ACTION_JSP"/></th>                        
        <th><jetspeed:l10n key="JSP1_1ANDJETSPEEDTAGLIB_RETURNED_VALUE_JSP"/></th>
      </tr>
      <tr>
        <td><jetspeed:l10n key="JSP1_1ANDJETSPEEDTAGLIB_HELLOVELOCITY_JSP"/></td>
        <td><jetspeed:l10n key="JSP1_1ANDJETSPEEDTAGLIB_USER_TURBINE_MEDIA_T_JSP"/></td>        
        <td><jetspeed:l10n key="JSP1_1ANDJETSPEEDTAGLIB_CONTROLS_PRINT_JSP"/></td>                
        <td><a href="<jetspeed:portletlink name="HelloVelocity" psml="user/turbine/media-type/html/page/default.psml" action="controls.Print"/>"><jetspeed:portletlink name="HelloVelocity" psml="user/turbine/media-type/html/page/default.psml" action="controls.Print"/></A></td>
      </tr>
      <tr>
        <td><jetspeed:l10n key="JSP1_1ANDJETSPEEDTAGLIB_DATABASEBROWSERTEST_JSP"/></td>
        <td></td>        
        <td></td>                
        <td><a href="<jetspeed:portletlink name="DatabaseBrowserTest" />"><jetspeed:portletlink name="DatabaseBrowserTest" /></A></td>
      </tr>
    </table>

    <center><h2><jetspeed:l10n key="JSP1_1ANDJETSPEEDTAGLIB_JETSPEED_L10N_JSP"/></h2></center>
    <table>
      <tr>
        <th><jetspeed:l10n key="JSP1_1ANDJETSPEEDTAGLIB_KEY_JSP"/></th>
        <th><jetspeed:l10n key="JSP1_1ANDJETSPEEDTAGLIB_ALT_JSP"/></th>        
        <th><jetspeed:l10n key="JSP1_1ANDJETSPEEDTAGLIB_RETURNED_VALUE_JSP"/></th>
      </tr>
      <tr>
        <td><jetspeed:l10n key="JSP1_1ANDJETSPEEDTAGLIB_LOGIN_USERNAME_JSP"/></td>
        <td>&nbsp;</td>        
        <td><jetspeed:l10n key="LOGIN_USERNAME" /></td>
      </tr>
      <tr>
        <td><jetspeed:l10n key="JSP1_1ANDJETSPEEDTAGLIB_NOT_LOCALIZED_JSP"/></td>
        <td>&nbsp;</td>        
        <td><jetspeed:l10n key="NOT_LOCALIZED" /></td>
      </tr>
      <tr>
        <td><jetspeed:l10n key="JSP1_1ANDJETSPEEDTAGLIB_NOT_LOCALIZED_JSP"/></td>
        <td><jetspeed:l10n key="JSP1_1ANDJETSPEEDTAGLIB_ALTERNATIVE_TRANSLAT_JSP"/></td>        
        <td><jetspeed:l10n key="NOT_LOCALIZED" alt="Alternative translation" /></td>
      </tr>
    </table>

    <center><h2><jetspeed:l10n key="JSP1_1ANDJETSPEEDTAGLIB_JETSPEED_PARAMETERST_JSP"/></h2></center>
    <table>
      <tr>
        <th><jetspeed:l10n key="JSP1_1ANDJETSPEEDTAGLIB_NAME_JSP"/></th>
        <th><jetspeed:l10n key="JSP1_1ANDJETSPEEDTAGLIB_STYLE_JSP"/></th>        
        <th><jetspeed:l10n key="JSP1_1ANDJETSPEEDTAGLIB_VALUE_JSP"/></th>                
        <th><jetspeed:l10n key="JSP1_1ANDJETSPEEDTAGLIB_OPTIONS_JSP"/></th>                
        <th><jetspeed:l10n key="JSP1_1ANDJETSPEEDTAGLIB_RETURNED_VALUE_JSP"/></th>
      </tr>
      <tr>
        <td><jetspeed:l10n key="JSP1_1ANDJETSPEEDTAGLIB_PORTLET_LIST_JSP"/></td>
        <td><jetspeed:l10n key="JSP1_1ANDJETSPEEDTAGLIB_REGISTRYENTRYLISTBOX_JSP"/></td>  
        <td>&nbsp;</td>                              
        <td>&nbsp;</td>                
        <td><jetspeed:parameterStyle name="porlet-list" style="RegistryEntryListBox"/></td>
      </tr>
      <tr>
        <td><jetspeed:l10n key="JSP1_1ANDJETSPEEDTAGLIB_SKIN_LIST_JSP"/></td>
        <td><jetspeed:l10n key="JSP1_1ANDJETSPEEDTAGLIB_REGISTRYENTRYLISTBOX_JSP"/></td>  
        <td>&nbsp;</td>                              
        <td><jetspeed:l10n key="JSP1_1ANDJETSPEEDTAGLIB_REGISTRY_SKIN_SET_LA_JSP"/></td>                
        <td><jetspeed:parameterStyle name="skin-list" style="RegistryEntryListBox"><jetspeed:l10n key="JSP1_1ANDJETSPEEDTAGLIB_REGISTRY_SKIN_JSP"/></jetspeed:parameterStyle></td>
      </tr>
      <tr>
        <td><jetspeed:l10n key="JSP1_1ANDJETSPEEDTAGLIB_CONTROL_LIST_JSP"/></td>
        <td><jetspeed:l10n key="JSP1_1ANDJETSPEEDTAGLIB_REGISTRYENTRYLISTBOX_JSP"/></td>  
        <td><jetspeed:l10n key="JSP1_1ANDJETSPEEDTAGLIB_TABCONTROL_JSP"/></td>                              
        <td><jetspeed:l10n key="JSP1_1ANDJETSPEEDTAGLIB_REGISTRY_PORTLETCONT_JSP"/></td>                
        <td><jetspeed:parameterStyle name="control-list" style="RegistryEntryListBox" value="TabControl"><jetspeed:l10n key="JSP1_1ANDJETSPEEDTAGLIB_REGISTRY_PORTLETCONT_JSP"/></jetspeed:parameterStyle></td>
      </tr>
    </table>

    <hr/>
    <center><h1><jetspeed:l10n key="JSP1_1ANDJETSPEEDTAGLIB_HTTP_REQUEST_HEADER_JSP"/></h1></center>
    <table>
      <tr>
        <th><jetspeed:l10n key="JSP1_1ANDJETSPEEDTAGLIB_NAME_JSP"/></th>
        <th><jetspeed:l10n key="JSP1_1ANDJETSPEEDTAGLIB_RETURNED_VALUE_JSP"/></th>
      </tr>
      <tr>
        <td><jetspeed:l10n key="JSP1_1ANDJETSPEEDTAGLIB_AUTH_TYPE_JSP"/></td>
        <td><%= request.getAuthType() %></td>
      </tr>
      <tr>
        <td><jetspeed:l10n key="JSP1_1ANDJETSPEEDTAGLIB_CHARACTER_ENCODING_JSP"/></td>
        <td><%= request.getCharacterEncoding() %></td>
      </tr>
      <tr>
        <td><jetspeed:l10n key="JSP1_1ANDJETSPEEDTAGLIB_CONTENT_LENGTH_JSP"/></td>
        <td><%= request.getContentLength() %></td>
      </tr>
      <tr>
        <td><jetspeed:l10n key="JSP1_1ANDJETSPEEDTAGLIB_CONTENT_TYPE_JSP"/></td>
        <td><%= request.getContentType() %></td>
      </tr>
      <tr>
        <td><jetspeed:l10n key="JSP1_1ANDJETSPEEDTAGLIB_CONTEXT_PATH_JSP"/></td>
        <td><%= request.getContextPath() %></td>
      </tr>
      <tr>
        <td><jetspeed:l10n key="JSP1_1ANDJETSPEEDTAGLIB_METHOD_JSP"/></td>
        <td><%= request.getMethod() %></td>
      </tr>
      <tr>
        <td><jetspeed:l10n key="JSP1_1ANDJETSPEEDTAGLIB_PATH_INFO_JSP"/></td>
        <td><%= request.getPathInfo() %></td>
      </tr>
      <tr>
        <td><jetspeed:l10n key="JSP1_1ANDJETSPEEDTAGLIB_PATH_TRANSLATED_JSP"/></td>
        <td><%= request.getPathTranslated() %></td>
      </tr>
      <tr>
        <td><jetspeed:l10n key="JSP1_1ANDJETSPEEDTAGLIB_PROTOCOL_JSP"/></td>
        <td><%= request.getProtocol() %></td>
      </tr>
      <tr>
        <td><jetspeed:l10n key="JSP1_1ANDJETSPEEDTAGLIB_QUERY_STRING_JSP"/></td>
        <td><%= request.getQueryString() %></td>
      </tr>
      <tr>
        <td><jetspeed:l10n key="JSP1_1ANDJETSPEEDTAGLIB_REMOTE_ADDRESS_JSP"/></td>
        <td><%= request.getRemoteAddr() %></td>
      </tr>
      <tr>
        <td><jetspeed:l10n key="JSP1_1ANDJETSPEEDTAGLIB_REMOTE_HOST_JSP"/></td>
        <td><%= request.getRemoteHost() %></td>
      </tr>
      <tr>
        <td><jetspeed:l10n key="JSP1_1ANDJETSPEEDTAGLIB_REMOTE_USER_JSP"/></td>
        <td><%= request.getRemoteUser() %></td>
      </tr>
      <tr>
        <td><jetspeed:l10n key="JSP1_1ANDJETSPEEDTAGLIB_REQUESTED_SESSION_ID_JSP"/></td>
        <td><%= request.getRequestedSessionId() %></td>
      </tr>
      <tr>
        <td><jetspeed:l10n key="JSP1_1ANDJETSPEEDTAGLIB_REQUESTED_SESSION_ID_JSP"/></td>
        <td><%= request.isRequestedSessionIdFromCookie() %></td>
      </tr>
      <tr>
        <td><jetspeed:l10n key="JSP1_1ANDJETSPEEDTAGLIB_REQUESTED_SESSION_ID_JSP"/></td>
        <td><%= request.isRequestedSessionIdFromURL() %></td>
      </tr>
      <tr>
        <td><jetspeed:l10n key="JSP1_1ANDJETSPEEDTAGLIB_REQUEST_URI_JSP"/></td>
        <td><%= request.getRequestURI() %></td>
      </tr>
      <tr>
        <td><jetspeed:l10n key="JSP1_1ANDJETSPEEDTAGLIB_SCHEME_JSP"/></td>
        <td><%= request.getScheme() %></td>
      </tr>
      <tr>
        <td><jetspeed:l10n key="JSP1_1ANDJETSPEEDTAGLIB_SECURE_JSP"/></td>
        <td><%= request.isSecure() %></td>
      </tr>
      <tr>
        <td><jetspeed:l10n key="JSP1_1ANDJETSPEEDTAGLIB_SERVER_NAME_JSP"/></td>
        <td><%= request.getServerName() %></td>
      </tr>
      <tr>
        <td><jetspeed:l10n key="JSP1_1ANDJETSPEEDTAGLIB_SERVER_PORT_JSP"/></td>
        <td><%= request.getServerPort() %></td>
      </tr>
      <tr>
        <td><jetspeed:l10n key="JSP1_1ANDJETSPEEDTAGLIB_SERVLET_PATH_JSP"/></td>
        <td><%= request.getServletPath() %></td>
      </tr>
    </table>

    <center><h2><jetspeed:l10n key="JSP1_1ANDJETSPEEDTAGLIB_HTTP_HEADERS_JSP"/></h2></center>
    <table>
      <tr>
        <th><jetspeed:l10n key="JSP1_1ANDJETSPEEDTAGLIB_NAME_JSP"/></th>
        <th><jetspeed:l10n key="JSP1_1ANDJETSPEEDTAGLIB_VALUE_JSP"/></th>
      </tr>
<%
      Enumeration e = request.getHeaderNames();

      while (e.hasMoreElements()) {
        String name = (String)e.nextElement();
        String value = request.getHeader(name);
        out.println("<tr><td>" + name + "</td><td>" + value + "</td></tr>");
      }
%>
    </table>

    <center><h2><jetspeed:l10n key="JSP1_1ANDJETSPEEDTAGLIB_ATTRIBUTES_JSP"/></h2></center>
    <table>
      <tr>
        <th><jetspeed:l10n key="JSP1_1ANDJETSPEEDTAGLIB_NAME_JSP"/></th>
      </tr>
<%
      e = request.getAttributeNames();

      while (e.hasMoreElements()) {
        String name = (String)e.nextElement();
        out.println("<tr><td>" + name + "</td></tr>");
      }
%>
    </table>

    <center><h2><jetspeed:l10n key="JSP1_1ANDJETSPEEDTAGLIB_PARAMETERS_JSP"/></h2></center>
    <table>
      <tr>
        <th><jetspeed:l10n key="JSP1_1ANDJETSPEEDTAGLIB_NAME_JSP"/></th>
        <th><jetspeed:l10n key="JSP1_1ANDJETSPEEDTAGLIB_VALUE_JSP"/></th>
      </tr>
<%
      e = request.getParameterNames();

      while (e.hasMoreElements()) {
        String name = (String)e.nextElement();
        String value = request.getParameter(name);
        out.println("<tr><td>" + name + "</td><td>" + value + "</td></tr>");
      }
%>
    </table>
    <center><h2><jetspeed:l10n key="JSP1_1ANDJETSPEEDTAGLIB_COOKIES_JSP"/></h2></center>
    <table>
      <tr>
        <th><jetspeed:l10n key="JSP1_1ANDJETSPEEDTAGLIB_NAME_JSP"/></th>
        <th><jetspeed:l10n key="JSP1_1ANDJETSPEEDTAGLIB_VALUE_JSP"/></th>
      </tr>
<%
      Cookie[] cookies = request.getCookies();

      if (cookies != null)
      {
        for (int i = 0; i < cookies.length; i++)
        {
          out.println("<tr><td>" + cookies[i].getName() + "</td><td>" + cookies[i].getValue() + "</td></tr>");
        }
      }
%>
    </table>
  </body>
</html>