package org.apache.jetspeed.om.dbregistry;


import java.math.BigDecimal;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;

import org.apache.commons.lang.ObjectUtils;
import org.apache.torque.TorqueException;
import org.apache.torque.om.BaseObject;
import org.apache.torque.om.ComboKey;
import org.apache.torque.om.DateKey;
import org.apache.torque.om.NumberKey;
import org.apache.torque.om.ObjectKey;
import org.apache.torque.om.SimpleKey;
import org.apache.torque.om.StringKey;
import org.apache.torque.om.Persistent;
import org.apache.torque.util.Criteria;
import org.apache.torque.util.Transaction;

  
  
/**
 * This class was autogenerated by Torque on:
 *
 * [Thu Jun 10 23:17:32 JST 2004]
 *
 * You should not use this class directly.  It should not even be
 * extended all references should be to PortletParameter
 */
public abstract class BasePortletParameter extends BaseObject
{
    /** The Peer class */
    private static final PortletParameterPeer peer =
        new PortletParameterPeer();

      
    /** The value for the id field */
    private long id;
      
    /** The value for the name field */
    private String name;
                                                
    /** The value for the value field */
    private String value="0";
      
    /** The value for the type field */
    private String type;
                                                                
    /** The value for the hidden field */
    private boolean hidden=false;
      
    /** The value for the role field */
    private String role;
                                                                
    /** The value for the cachedonvalue field */
    private boolean cachedonvalue=true;
                                                                
    /** The value for the cachedonname field */
    private boolean cachedonname=true;
      
    /** The value for the title field */
    private String title;
      
    /** The value for the description field */
    private String description;
      
    /** The value for the image field */
    private String image;
      
    /** The value for the portletId field */
    private long portletId;
      
    /** The value for the securityRef field */
    private String securityRef;
  
  
    /**
     * Get the Id
     * @return long
     */
    public long getId()
    {
        return id;
    }

                        
    /**
     * Set the value of Id
     */
    public void setId(long v ) 
    {
    
                  if (this.id != v)
              {
            this.id = v;
            setModified(true);
        }
    
          
              }

  
    /**
     * Get the Name
     * @return String
     */
    public String getName()
    {
        return name;
    }

                        
    /**
     * Set the value of Name
     */
    public void setName(String v ) 
    {
    
                  if (!ObjectUtils.equals(this.name, v))
              {
            this.name = v;
            setModified(true);
        }
    
          
              }

  
    /**
     * Get the Value
     * @return String
     */
    public String getValue()
    {
        return value;
    }

                        
    /**
     * Set the value of Value
     */
    public void setValue(String v ) 
    {
    
                  if (!ObjectUtils.equals(this.value, v))
              {
            this.value = v;
            setModified(true);
        }
    
          
              }

  
    /**
     * Get the Type
     * @return String
     */
    public String getType()
    {
        return type;
    }

                        
    /**
     * Set the value of Type
     */
    public void setType(String v ) 
    {
    
                  if (!ObjectUtils.equals(this.type, v))
              {
            this.type = v;
            setModified(true);
        }
    
          
              }

  
    /**
     * Get the Hidden
     * @return boolean
     */
    public boolean getHidden()
    {
        return hidden;
    }

                        
    /**
     * Set the value of Hidden
     */
    public void setHidden(boolean v ) 
    {
    
                  if (this.hidden != v)
              {
            this.hidden = v;
            setModified(true);
        }
    
          
              }

  
    /**
     * Get the Role
     * @return String
     */
    public String getRole()
    {
        return role;
    }

                        
    /**
     * Set the value of Role
     */
    public void setRole(String v ) 
    {
    
                  if (!ObjectUtils.equals(this.role, v))
              {
            this.role = v;
            setModified(true);
        }
    
          
              }

  
    /**
     * Get the Cachedonvalue
     * @return boolean
     */
    public boolean getCachedonvalue()
    {
        return cachedonvalue;
    }

                        
    /**
     * Set the value of Cachedonvalue
     */
    public void setCachedonvalue(boolean v ) 
    {
    
                  if (this.cachedonvalue != v)
              {
            this.cachedonvalue = v;
            setModified(true);
        }
    
          
              }

  
    /**
     * Get the Cachedonname
     * @return boolean
     */
    public boolean getCachedonname()
    {
        return cachedonname;
    }

                        
    /**
     * Set the value of Cachedonname
     */
    public void setCachedonname(boolean v ) 
    {
    
                  if (this.cachedonname != v)
              {
            this.cachedonname = v;
            setModified(true);
        }
    
          
              }

  
    /**
     * Get the Title
     * @return String
     */
    public String getTitle()
    {
        return title;
    }

                        
    /**
     * Set the value of Title
     */
    public void setTitle(String v ) 
    {
    
                  if (!ObjectUtils.equals(this.title, v))
              {
            this.title = v;
            setModified(true);
        }
    
          
              }

  
    /**
     * Get the Description
     * @return String
     */
    public String getDescription()
    {
        return description;
    }

                        
    /**
     * Set the value of Description
     */
    public void setDescription(String v ) 
    {
    
                  if (!ObjectUtils.equals(this.description, v))
              {
            this.description = v;
            setModified(true);
        }
    
          
              }

  
    /**
     * Get the Image
     * @return String
     */
    public String getImage()
    {
        return image;
    }

                        
    /**
     * Set the value of Image
     */
    public void setImage(String v ) 
    {
    
                  if (!ObjectUtils.equals(this.image, v))
              {
            this.image = v;
            setModified(true);
        }
    
          
              }

  
    /**
     * Get the PortletId
     * @return long
     */
    public long getPortletId()
    {
        return portletId;
    }

                              
    /**
     * Set the value of PortletId
     */
    public void setPortletId(long v ) throws TorqueException
    {
    
                  if (this.portletId != v)
              {
            this.portletId = v;
            setModified(true);
        }
    
                                  
                if (aPortletDbEntry != null && !(aPortletDbEntry.getId() == v))
                {
            aPortletDbEntry = null;
        }
      
              }

  
    /**
     * Get the SecurityRef
     * @return String
     */
    public String getSecurityRef()
    {
        return securityRef;
    }

                        
    /**
     * Set the value of SecurityRef
     */
    public void setSecurityRef(String v ) 
    {
    
                  if (!ObjectUtils.equals(this.securityRef, v))
              {
            this.securityRef = v;
            setModified(true);
        }
    
          
              }

  
      
        
                  
        private PortletDbEntry aPortletDbEntry;

    /**
     * Declares an association between this object and a PortletDbEntry object
     *
     * @param PortletDbEntry v
     */
    public void setPortletDbEntry(PortletDbEntry v) throws TorqueException
    {
            if (v == null)
        {
                  setPortletId(0);
              }
        else
        {
            setPortletId(v.getId());
        }
            aPortletDbEntry = v;
    }

                        
    public PortletDbEntry getPortletDbEntry() throws TorqueException
    {
        if ( getPortletId()>0 )
        {
                return PortletDbEntryManager.getInstance(SimpleKey.keyFor(getPortletId()));
            }
        return aPortletDbEntry;
    }

    /**
     * Provides convenient way to set a relationship based on a
     * ObjectKey.  e.g.
     * <code>bar.setFooKey(foo.getPrimaryKey())</code>
     *
         */
    public void setPortletDbEntryKey(ObjectKey key) throws TorqueException
    {
    
                    setPortletId(((NumberKey) key).longValue());
              }

     
                
    private static List fieldNames = null;

    /**
     * Generate a list of field names.
     */
    public static synchronized List getFieldNames()
    {
        if (fieldNames == null)
        {
            fieldNames = new ArrayList();
              fieldNames.add("Id");
              fieldNames.add("Name");
              fieldNames.add("Value");
              fieldNames.add("Type");
              fieldNames.add("Hidden");
              fieldNames.add("Role");
              fieldNames.add("Cachedonvalue");
              fieldNames.add("Cachedonname");
              fieldNames.add("Title");
              fieldNames.add("Description");
              fieldNames.add("Image");
              fieldNames.add("PortletId");
              fieldNames.add("SecurityRef");
              fieldNames = Collections.unmodifiableList(fieldNames);
        }
        return fieldNames;
    }

    /**
     * Retrieves a field from the object by name passed in
     * as a String.
     */
    public Object getByName(String name)
    {
          if (name.equals("Id"))
        {
                return new Long(getId());
            }
          if (name.equals("Name"))
        {
                return getName();
            }
          if (name.equals("Value"))
        {
                return getValue();
            }
          if (name.equals("Type"))
        {
                return getType();
            }
          if (name.equals("Hidden"))
        {
                return new Boolean(getHidden());
            }
          if (name.equals("Role"))
        {
                return getRole();
            }
          if (name.equals("Cachedonvalue"))
        {
                return new Boolean(getCachedonvalue());
            }
          if (name.equals("Cachedonname"))
        {
                return new Boolean(getCachedonname());
            }
          if (name.equals("Title"))
        {
                return getTitle();
            }
          if (name.equals("Description"))
        {
                return getDescription();
            }
          if (name.equals("Image"))
        {
                return getImage();
            }
          if (name.equals("PortletId"))
        {
                return new Long(getPortletId());
            }
          if (name.equals("SecurityRef"))
        {
                return getSecurityRef();
            }
          return null;
    }
    
    /**
     * Retrieves a field from the object by name passed in
     * as a String.  The String must be one of the static
     * Strings defined in this Class' Peer.
     */
    public Object getByPeerName(String name)
    {
          if (name.equals(PortletParameterPeer.ID ))
        {
                return new Long(getId());
            }
          if (name.equals(PortletParameterPeer.NAME ))
        {
                return getName();
            }
          if (name.equals(PortletParameterPeer.VALUE ))
        {
                return getValue();
            }
          if (name.equals(PortletParameterPeer.TYPE ))
        {
                return getType();
            }
          if (name.equals(PortletParameterPeer.HIDDEN ))
        {
                return new Boolean(getHidden());
            }
          if (name.equals(PortletParameterPeer.ROLE ))
        {
                return getRole();
            }
          if (name.equals(PortletParameterPeer.CACHEDONVALUE ))
        {
                return new Boolean(getCachedonvalue());
            }
          if (name.equals(PortletParameterPeer.CACHEDONNAME ))
        {
                return new Boolean(getCachedonname());
            }
          if (name.equals(PortletParameterPeer.TITLE ))
        {
                return getTitle();
            }
          if (name.equals(PortletParameterPeer.DESCRIPTION ))
        {
                return getDescription();
            }
          if (name.equals(PortletParameterPeer.IMAGE ))
        {
                return getImage();
            }
          if (name.equals(PortletParameterPeer.PORTLET_ID ))
        {
                return new Long(getPortletId());
            }
          if (name.equals(PortletParameterPeer.SECURITY ))
        {
                return getSecurityRef();
            }
          return null;
    }

    /**
     * Retrieves a field from the object by Position as specified
     * in the xml schema.  Zero-based.
     */
    public Object getByPosition(int pos)
    {
            if ( pos == 0 )
        {
                return new Long(getId());
            }
              if ( pos == 1 )
        {
                return getName();
            }
              if ( pos == 2 )
        {
                return getValue();
            }
              if ( pos == 3 )
        {
                return getType();
            }
              if ( pos == 4 )
        {
                return new Boolean(getHidden());
            }
              if ( pos == 5 )
        {
                return getRole();
            }
              if ( pos == 6 )
        {
                return new Boolean(getCachedonvalue());
            }
              if ( pos == 7 )
        {
                return new Boolean(getCachedonname());
            }
              if ( pos == 8 )
        {
                return getTitle();
            }
              if ( pos == 9 )
        {
                return getDescription();
            }
              if ( pos == 10 )
        {
                return getImage();
            }
              if ( pos == 11 )
        {
                return new Long(getPortletId());
            }
              if ( pos == 12 )
        {
                return getSecurityRef();
            }
              return null;
    }
     
    /**
     * Stores the object in the database.  If the object is new,
     * it inserts it; otherwise an update is performed.
     */
    public void save() throws Exception
    {
          save(PortletParameterPeer.getMapBuilder()
                .getDatabaseMap().getName());
      }

    /**
     * Stores the object in the database.  If the object is new,
     * it inserts it; otherwise an update is performed.
       * Note: this code is here because the method body is
     * auto-generated conditionally and therefore needs to be
     * in this file instead of in the super class, BaseObject.
       */
    public void save(String dbName) throws TorqueException
    {
        Connection con = null;
          try
        {
            con = Transaction.begin(dbName);
            save(con);
            Transaction.commit(con);
        }
        catch(TorqueException e)
        {
            Transaction.safeRollback(con);
            throw e;
        }
      }

      /** flag to prevent endless save loop, if this object is referenced
        by another object which falls in this transaction. */
    private boolean alreadyInSave = false;
      /**
     * Stores the object in the database.  If the object is new,
     * it inserts it; otherwise an update is performed.  This method
     * is meant to be used as part of a transaction, otherwise use
     * the save() method and the connection details will be handled
     * internally
     */
    public void save(Connection con) throws TorqueException
    {
          if (!alreadyInSave)
        {
            alreadyInSave = true;


  
            // If this object has been modified, then save it to the database.
            if (isModified())
            {
                if (isNew())
                {
                    PortletParameterPeer.doInsert((PortletParameter)this, con);
                    setNew(false);
                }
                else
                {
                    PortletParameterPeer.doUpdate((PortletParameter)this, con);
                }

                      if (isCacheOnSave())
                {
                    PortletParameterManager.putInstance(this);
                }
              }

                      alreadyInSave = false;
        }
      }

    /**
     * Specify whether to cache the object after saving to the db.
     * This method returns false
     */
    protected boolean isCacheOnSave()
    {
        return true;
    }

                  
      /**
     * Set the PrimaryKey using ObjectKey.
     *
     * @param ObjectKey id
     */
    public void setPrimaryKey(ObjectKey id)
         {
            setId(((NumberKey)id).longValue());
        }

    /**
     * Set the PrimaryKey using a String.
     */
    public void setPrimaryKey(String key) 
    {
            setId(Long.parseLong(key));
        }

  
    /**
     * returns an id that differentiates this object from others
     * of its class.
     */
    public ObjectKey getPrimaryKey()
    {
          return SimpleKey.keyFor(getId());
      }
 

    /**
     * Makes a copy of this object.
     * It creates a new object filling in the simple attributes.
       * It then fills all the association collections.
       */
      public PortletParameter copy() throws TorqueException
    {
        PortletParameter copyObj = new PortletParameter();
            copyObj.setId(id);
          copyObj.setName(name);
          copyObj.setValue(value);
          copyObj.setType(type);
          copyObj.setHidden(hidden);
          copyObj.setRole(role);
          copyObj.setCachedonvalue(cachedonvalue);
          copyObj.setCachedonname(cachedonname);
          copyObj.setTitle(title);
          copyObj.setDescription(description);
          copyObj.setImage(image);
          copyObj.setPortletId(portletId);
          copyObj.setSecurityRef(securityRef);
  
                      copyObj.setId(0);
                                                                                    
                return copyObj;
    }

    /**
     * returns a peer instance associated with this om.  Since Peer classes
     * are not to have any instance attributes, this method returns the
     * same instance for all member of this class. The method could therefore
     * be static, but this would prevent one from overriding the behavior.
     */
    public PortletParameterPeer getPeer()
    {
        return peer;
    }
}
