/*
 * Aipo is a groupware program developed by Aimluck,Inc.
 * http://aipostyle.com/
 * 
 * Copyright(C) 2010 avanza Co.,Ltd. All rights reserved.
 * http://www.avnz.co.jp/
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */
package com.aimluck.eip.extcabinet;

import java.io.File;
import java.util.ArrayList;
import java.util.List;

import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

import com.aimluck.eip.cayenne.om.portlet.AvzTCabinetFile;
import com.aimluck.eip.common.ALAbstractCheckList;
import com.aimluck.eip.extcabinet.util.ExtCabinetUtils;
import com.aimluck.eip.orm.Database;
import com.aimluck.eip.orm.DatabaseOrmService;
import com.aimluck.eip.orm.query.ResultList;
import com.aimluck.eip.orm.query.SelectQuery;
import com.aimluck.eip.services.accessctl.ALAccessControlConstants;

/**
 * 文書管理のファイルの複数削除を行うためのクラスです。 <BR>
 * 
 */
public class ExtCabinetFileMultiDelete extends ALAbstractCheckList {

  /** logger */
  private static final JetspeedLogger logger =
    JetspeedLogFactoryService.getLogger(ExtCabinetFileMultiDelete.class
      .getName());

  /**
   * 
   * @param rundata
   * @param context
   * @param values
   * @param msgList
   * @return
   * @see com.aimluck.eip.common.ALAbstractCheckList#action(org.apache.turbine.util.RunData,
   *      org.apache.velocity.context.Context, java.util.ArrayList,
   *      java.util.ArrayList)
   */
  @Override
  protected boolean action(RunData rundata, Context context,
      List<String> values, List<String> msgList) {
    try {

      SelectQuery<AvzTCabinetFile> query =
        Database.query(AvzTCabinetFile.class);
      Expression exp =
        ExpressionFactory.inDbExp(AvzTCabinetFile.FILE_ID_PK_COLUMN, values);
      query.setQualifier(exp);

      ResultList<AvzTCabinetFile> filelist = query.getResultList();
      if (filelist == null || filelist.size() == 0) {
        return false;
      }

      for (int i = 0; i < filelist.size(); i++) {
        if (!ExtCabinetUtils.isDeletableFile(
          (filelist.get(i)).getFileId(),
          rundata)) {
          msgList.add("削除する権限の無いファイルが含まれています。");
          return false;
        }

        List<String> fpaths = new ArrayList<String>();
        for (i = 0; i < filelist.size(); i++) {
          AvzTCabinetFile cabinetfile = filelist.get(i);
          fpaths.add(cabinetfile.getFilePath());
        }

        // ファイルを削除
        int filelistsize = filelist.size();
        for (i = 0; i < filelistsize; i++) {
          AvzTCabinetFile file = filelist.get(i);
          // fileを削除
          Database.delete(file);
          Database.commit();
        }
        int fpathSize = fpaths.size();
        if (fpathSize > 0) {
          // ローカルファイルに保存されているファイルを削除する．
          String org_id = DatabaseOrmService.getInstance().getOrgId(rundata);
          File file = null;
          for (i = 0; i < fpathSize; i++) {
            file =
              new File(ExtCabinetUtils.getSaveDirPath(org_id) + fpaths.get(i));
            if (file.exists()) {
              file.delete();
            }
          }
        }
      }
    } catch (Exception ex) {
      Database.rollback();
      logger.error("Exception", ex);
      return false;
    }
    return true;
  }

  /**
   * アクセス権限チェック用メソッド。<br />
   * アクセス権限を返します。
   * 
   * @return
   */
  @Override
  protected int getDefineAclType() {
    return ALAccessControlConstants.VALUE_ACL_DELETE;
  }

  /**
   * アクセス権限チェック用メソッド。<br />
   * アクセス権限の機能名を返します。
   * 
   * @return
   */
  @Override
  public String getAclPortletFeature() {
    return null;
  }
}
