/*
 * Aipo is a groupware program developed by Aimluck,Inc.
 * http://aipostyle.com/
 * 
 * Copyright(C) 2010 avanza Co.,Ltd. All rights reserved.
 * http://www.avnz.co.jp/
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */
package com.aimluck.eip.extcabinet.beans;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;

import com.aimluck.commons.field.ALNumberField;
import com.aimluck.commons.field.ALStringField;
import com.aimluck.eip.extcabinet.ExtFolderInfo;
import com.aimluck.eip.common.ALData;

/**
 * 文書管理のフォルダ階層データを管理するクラスです。
 *
 */
public class ExtCabinetBean implements ALData, Cloneable {

  /** <code>cabinet_id</code> フォルダまたはファイルID */
  private ALNumberField cabinet_id;

  /** <code>cabinet_name</code> フォルダまたはファイル名 */
  private ALStringField cabinet_name;

  /** <code>type</code> タイプ */
  private ALNumberField type;

  /** <code>cabinet_child</code> フォルダの中の要素 */
  private List<Hashtable> cabinet_child;

  /*
   * @see com.aimluck.eip.common.ALData#initField()
   */
  public void initField() {
    cabinet_id = new ALNumberField();
    cabinet_name = new ALStringField();
    cabinet_child = new ArrayList<Hashtable>();
    type = new ALNumberField();
  }

  public void setResultData(ExtFolderInfo info) {
  }

  public int getcabinetid() {
    return (int) cabinet_id.getValue();
  }

  public void setCabinetId(int number) {
    cabinet_id.setValue(number);
  }

  public String getCabinetName() {
    return cabinet_name.toString();
  }

  public void setCabinetName(String str) {
    cabinet_name.setValue(str);
  }

  public List<Hashtable> getchildren() {
    return cabinet_child;
  }

  public void setCabinetChild(List<Hashtable> list) {
    cabinet_child = list;
  }

  public String gettype() {
    return type.toString();
  }

  public void settype(int i) {
    type.setValue(i);
  }
  
  @Override
  protected Object clone() throws CloneNotSupportedException {
    return super.clone();
  }
}
