package org.apache.jetspeed.om.apps.email;


import java.math.BigDecimal;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;

import org.apache.commons.lang.ObjectUtils;
import org.apache.torque.TorqueException;
import org.apache.torque.om.BaseObject;
import org.apache.torque.om.ComboKey;
import org.apache.torque.om.DateKey;
import org.apache.torque.om.NumberKey;
import org.apache.torque.om.ObjectKey;
import org.apache.torque.om.SimpleKey;
import org.apache.torque.om.StringKey;
import org.apache.torque.om.Persistent;
import org.apache.torque.util.Criteria;
import org.apache.torque.util.Transaction;


/**
 * This class was autogenerated by Torque on:
 *
 * [Thu Jun 10 23:17:32 JST 2004]
 *
 * You should not use this class directly.  It should not even be
 * extended all references should be to EmailInbox
 */
public abstract class BaseEmailInbox extends BaseObject
{
    /** The Peer class */
    private static final EmailInboxPeer peer =
        new EmailInboxPeer();

      
    /** The value for the emailInboxId field */
    private int emailInboxId;
      
    /** The value for the messageId field */
    private String messageId;
      
    /** The value for the filename field */
    private String filename;
      
    /** The value for the attachment field */
    private byte[] attachment;
      
    /** The value for the readflag field */
    private int readflag;
  
  
    /**
     * Get the EmailInboxId
     * @return int
     */
    public int getEmailInboxId()
    {
        return emailInboxId;
    }

                        
    /**
     * Set the value of EmailInboxId
     */
    public void setEmailInboxId(int v ) 
    {
    
                  if (this.emailInboxId != v)
              {
            this.emailInboxId = v;
            setModified(true);
        }
    
          
              }

  
    /**
     * Get the MessageId
     * @return String
     */
    public String getMessageId()
    {
        return messageId;
    }

                        
    /**
     * Set the value of MessageId
     */
    public void setMessageId(String v ) 
    {
    
                  if (!ObjectUtils.equals(this.messageId, v))
              {
            this.messageId = v;
            setModified(true);
        }
    
          
              }

  
    /**
     * Get the Filename
     * @return String
     */
    public String getFilename()
    {
        return filename;
    }

                        
    /**
     * Set the value of Filename
     */
    public void setFilename(String v ) 
    {
    
                  if (!ObjectUtils.equals(this.filename, v))
              {
            this.filename = v;
            setModified(true);
        }
    
          
              }

  
    /**
     * Get the Attachment
     * @return byte[]
     */
    public byte[] getAttachment()
    {
        return attachment;
    }

                        
    /**
     * Set the value of Attachment
     */
    public void setAttachment(byte[] v ) 
    {
    
                  if (!ObjectUtils.equals(this.attachment, v))
              {
            this.attachment = v;
            setModified(true);
        }
    
          
              }

  
    /**
     * Get the Readflag
     * @return int
     */
    public int getReadflag()
    {
        return readflag;
    }

                        
    /**
     * Set the value of Readflag
     */
    public void setReadflag(int v ) 
    {
    
                  if (this.readflag != v)
              {
            this.readflag = v;
            setModified(true);
        }
    
          
              }

  
         
                
    private static List fieldNames = null;

    /**
     * Generate a list of field names.
     */
    public static synchronized List getFieldNames()
    {
        if (fieldNames == null)
        {
            fieldNames = new ArrayList();
              fieldNames.add("EmailInboxId");
              fieldNames.add("MessageId");
              fieldNames.add("Filename");
              fieldNames.add("Attachment");
              fieldNames.add("Readflag");
              fieldNames = Collections.unmodifiableList(fieldNames);
        }
        return fieldNames;
    }

    /**
     * Retrieves a field from the object by name passed in
     * as a String.
     */
    public Object getByName(String name)
    {
          if (name.equals("EmailInboxId"))
        {
                return new Integer(getEmailInboxId());
            }
          if (name.equals("MessageId"))
        {
                return getMessageId();
            }
          if (name.equals("Filename"))
        {
                return getFilename();
            }
          if (name.equals("Attachment"))
        {
                return getAttachment();
            }
          if (name.equals("Readflag"))
        {
                return new Integer(getReadflag());
            }
          return null;
    }
    
    /**
     * Retrieves a field from the object by name passed in
     * as a String.  The String must be one of the static
     * Strings defined in this Class' Peer.
     */
    public Object getByPeerName(String name)
    {
          if (name.equals(EmailInboxPeer.EMAIL_INBOX_ID ))
        {
                return new Integer(getEmailInboxId());
            }
          if (name.equals(EmailInboxPeer.MESSAGE_ID ))
        {
                return getMessageId();
            }
          if (name.equals(EmailInboxPeer.FILENAME ))
        {
                return getFilename();
            }
          if (name.equals(EmailInboxPeer.ATTACHMENT ))
        {
                return getAttachment();
            }
          if (name.equals(EmailInboxPeer.READFLAG ))
        {
                return new Integer(getReadflag());
            }
          return null;
    }

    /**
     * Retrieves a field from the object by Position as specified
     * in the xml schema.  Zero-based.
     */
    public Object getByPosition(int pos)
    {
            if ( pos == 0 )
        {
                return new Integer(getEmailInboxId());
            }
              if ( pos == 1 )
        {
                return getMessageId();
            }
              if ( pos == 2 )
        {
                return getFilename();
            }
              if ( pos == 3 )
        {
                return getAttachment();
            }
              if ( pos == 4 )
        {
                return new Integer(getReadflag());
            }
              return null;
    }
     
    /**
     * Stores the object in the database.  If the object is new,
     * it inserts it; otherwise an update is performed.
     */
    public void save() throws Exception
    {
          save(EmailInboxPeer.getMapBuilder()
                .getDatabaseMap().getName());
      }

    /**
     * Stores the object in the database.  If the object is new,
     * it inserts it; otherwise an update is performed.
       * Note: this code is here because the method body is
     * auto-generated conditionally and therefore needs to be
     * in this file instead of in the super class, BaseObject.
       */
    public void save(String dbName) throws TorqueException
    {
        Connection con = null;
          try
        {
            con = Transaction.begin(dbName);
            save(con);
            Transaction.commit(con);
        }
        catch(TorqueException e)
        {
            Transaction.safeRollback(con);
            throw e;
        }
      }

      /** flag to prevent endless save loop, if this object is referenced
        by another object which falls in this transaction. */
    private boolean alreadyInSave = false;
      /**
     * Stores the object in the database.  If the object is new,
     * it inserts it; otherwise an update is performed.  This method
     * is meant to be used as part of a transaction, otherwise use
     * the save() method and the connection details will be handled
     * internally
     */
    public void save(Connection con) throws TorqueException
    {
          if (!alreadyInSave)
        {
            alreadyInSave = true;


  
            // If this object has been modified, then save it to the database.
            if (isModified())
            {
                if (isNew())
                {
                    EmailInboxPeer.doInsert((EmailInbox)this, con);
                    setNew(false);
                }
                else
                {
                    EmailInboxPeer.doUpdate((EmailInbox)this, con);
                }

                      if (isCacheOnSave())
                {
                    EmailInboxManager.putInstance(this);
                }
              }

                      alreadyInSave = false;
        }
      }

    /**
     * Specify whether to cache the object after saving to the db.
     * This method returns false
     */
    protected boolean isCacheOnSave()
    {
        return true;
    }

                  
      /**
     * Set the PrimaryKey using ObjectKey.
     *
     * @param ObjectKey emailInboxId
     */
    public void setPrimaryKey(ObjectKey emailInboxId)
         {
            setEmailInboxId(((NumberKey)emailInboxId).intValue());
        }

    /**
     * Set the PrimaryKey using a String.
     */
    public void setPrimaryKey(String key) 
    {
            setEmailInboxId(Integer.parseInt(key));
        }

  
    /**
     * returns an id that differentiates this object from others
     * of its class.
     */
    public ObjectKey getPrimaryKey()
    {
          return SimpleKey.keyFor(getEmailInboxId());
      }
 

    /**
     * Makes a copy of this object.
     * It creates a new object filling in the simple attributes.
       * It then fills all the association collections.
       */
      public EmailInbox copy() throws TorqueException
    {
        EmailInbox copyObj = new EmailInbox();
            copyObj.setEmailInboxId(emailInboxId);
          copyObj.setMessageId(messageId);
          copyObj.setFilename(filename);
          copyObj.setAttachment(attachment);
          copyObj.setReadflag(readflag);
  
                      copyObj.setEmailInboxId(0);
                                    
                return copyObj;
    }

    /**
     * returns a peer instance associated with this om.  Since Peer classes
     * are not to have any instance attributes, this method returns the
     * same instance for all member of this class. The method could therefore
     * be static, but this would prevent one from overriding the behavior.
     */
    public EmailInboxPeer getPeer()
    {
        return peer;
    }
}
