#!/bin/ksh
#
#
#	CMSLOG.KSH
#	All Rights Reserved 1992,99 (C)

export PATH=".:$PATH:${CMSPATH}/bin"

case $# in
3) ;;
*) errmsg "Usage: cmslog (source-file) (user-name) (version(1 - 10))";exit;;
esac


if [ x${TABFILE} = x"" -o x${SYSNAME} = x"" ]
then
	errmsg "not found environment SYSNAME or TABFILE"
	exit
fi

File=$1
User=$2
Version=$3
SysName=${SYSNAME}
MainSource=${CMSPATH}/siten
Source=${CMSPATH}/src
Make=${CMSPATH}
DiffDir=${CMSPATH}/diff
Tabfile=${CMSPATH}/diff/tabs/${TABFILE}
Userfile=${CMSPATH}/diff/userfile
#Tree=`grep "${File}$" ${Tabfile} | sed -e 's/\.c$/_c/g' -e 's/\.h$/_h/g'`
Tree=`grep "${File}$" ${Tabfile} | sed -f ${CMSPATH}/bin/suffixes.sed`
Ftree=`grep "${File}$" ${Tabfile} | sed 's/\/'${File}'$//'`

grep -l "${File}" ${Tabfile} > /dev/null
if [ $? = 1 ]
then
	errmsg "$1 is no file"
	exit
fi
grep -l "$2" ${Userfile} > /dev/null
if [ $? = 1 ]
then
	errmsg "$2 is no user"
	exit
fi

CurentDir=`basename ${PWD}`
for i in `print - ${DiffDir}/ver_${Version}/${SYSNAME}/${Tree}/log_${Version}.*`
do
	echo "${File} - Version `basename ${i} | sed 's/^log_//'`"
	cat -s ${i}
done

