#!/bin/ksh
#
#	COMMENT.KSH
#	All Rights Reserved 1992 (C)
#
#    
#    COMMENT(21)              コメントの記録
#    
#    
#    名前
#    
#    　　comment.ksh
#    
#    使用法
#    
#    　　comment (MR-number) (user-name) (version-number)
#    
#    概要
#    
#    　　comment はリビジョン番号に対応した修正ごとのコメントを記録します。
#    
#    関連項目
#    
#    　　make(1) Makefile(1)
#    　　put(21) listfile(21) get(21) report(21) verlock(21) mr(21) mredit(21)
#

export PATH=".:$PATH:${CMSPATH}/bin"

case $# in
3) ;;
*) errmsg "Usage: $0 (MR-Number) (user-name) (version-number)"; exit ;;
esac

MainDir=${CMSPATH}
DiffDir=${CMSPATH}/diff
MrDir=${CMSPATH}/diff/mr
MrFile=mr
UserFile=${CMSPATH}/diff/userfile
SysName=${SYSNAME}
EidtCommand=${EDITOR}
CurentDir=`basename ${PWD}`
MrNumber=$1
UserName=$2
Version=$3

case $1 in
[0-9][0-9]) ;;
*) exit ;;
esac
grep -l ${UserName} ${UserFile}
case $? in
0) ;;
*) exit ;;
esac

case $3 in
1|2|3|4|5) ;;
*) exit ;;
esac

inpmsg Comment "全角４０字以内でコメントを入力して下さい。"
popmsg "コメントを登録します"
if [ $? = 0 ]
then
	exit
fi
#while true
#do
#	echo " >> \c"
#	read Comment
#	case ${Comment} in
#	"!") command.com ;;
#	"!q") exit ;;
#	".") break ;;
#	*) ;;
#	esac
#done

echo "${UserName};MR(${MrNumber});`date`" >> ${MrDir}/ver_${Version}/${SysName}/comment.log
echo "${Comment}" >> ${MrDir}/ver_${Version}/${SysName}/comment.log
echo "------------------------------------------------------------------------------" >> ${MrDir}/ver_${Version}/${SysName}/comment.log
