#!/bin/ksh
#
#	COMMIT.KSH
#	All Rights Reserved 2009 (C)
#
#	COMMIT(21)             ソースファイルの修正登録終了
#
#
#	名前
#
#	　　commit.ksh
#
#	使用法
#
#	　　commit (source-file-name) (user-name) (version-number)
#
#	概要
#
#		commit は getによって呼ばれたファイルのソースコードに修正が完了し
#		ていて、且つSUBMITフラグが登録されていたた場合だけ使用出来ます。
#		このときソースコードは最後の修正版だけが ~/cms/src/ver_[ 1 -10 ] 
#		にコピーされます。
#		これ以降 get vget put コマンドは現在のバージョンのファイルに対して
#		使用した場合、差分はイーブンとなるため変更記録は新規となります。
#
#	関連項目
#
#	　　make(1) Makefile(1)
#	　　put(21) get(21) vget(21) mr(21) report(21) reject(21) regist(21) submit

export PATH=".:$PATH:${CMSPATH}/bin"

case $# in
3) ;;
*) errmsg "Usage: commit (source-file) (user) (version(1 - 10))";exit;;
esac
case ${SYSNAME} in
"") errmsg "canot find system name form FMS environment."; exit ;;
esac

popmsg "COMMIT を実行すると原本ファイルはソースファイルと同期化されます。"
case $? in
1) ;;
*) exit ;;
esac

BaseDir=`basename ${PWD}`
File=$1
User=$2
Version=$3
CommitSource=${CMSPATH}/com/ver_${Version}
MainSource=${CMSPATH}/siten
Source=${CMSPATH}/src/${SYSNAME}
Object=${CMSPATH}/obj/${SYSNAME}
CommitLog=${CMSPATH}/diff/log/commitlog
Pmake=${CMSPATH}/fusr/${SYSNAME}
DiffDir=${CMSPATH}/diff
Tabfile=${CMSPATH}/diff/tabs/${TABFILE}
Okyatab=${CMSPATH}/diff/okyatab
Userfile=${CMSPATH}/diff/userfile
Target=`grep "^${File}$" ${Tabfile} | sed -f ${CMSPATH}/bin/suffixes.sed 2> /dev/null`
LockDir=`echo "${File}" | sed -f ${CMSPATH}/bin/suffixes.sed 2> /dev/null`
#VerTail=`tail -1 ${DiffDir}/lock/${SYSNAME}/${LockDir}/verfile.${Version} 2>/dev/null`
COMMIT_UPDATE=`date '+%Y/%m/%d,%H:%M'` 

if [ x$SYSNAME = x"" ]
then
	exit
fi
grep -l "^$1$" ${Tabfile} 2> /dev/null 1> /dev/null
if [ $? = 1 ]
then
	errmsg "$1 はテーブルに登録されていません"
	exit
fi
if [ x${Target} = x"" ]
then
	errmsg "ターゲットのファイルが見つかりません"
	exit
fi
grep -l "$2" ${Userfile} 2> /dev/null 1> /dev/null
if [ $? = 1 ]
then
	errmsg "$2 は登録されたユーザではありません"
	exit
fi
if [ ! -d ${DiffDir}/lock/${SYSNAME}/${LockDir} ]
then
	errmsg "このファイルは CMS でロックされています"
	exit
fi
grep -l "^commit" ${DiffDir}/lock/${SYSNAME}/${LockDir}/lkfile${Version} 2> /dev/null 1> /dev/null
if [ $? = 0 ]
then
	errmsg "$1 は COMMIT が終了しています。"
	exit
fi
grep -l "^submit" ${DiffDir}/lock/${SYSNAME}/${LockDir}/lkfile${Version} 2> /dev/null 1> /dev/null
if [ $? != 0 ]
then
	errmsg "$1 は SUBMIT が終了していません。"
	exit
fi

Tree=`grep "^${File}$" ${Tabfile}`
Ftree=`grep "^${File}$" ${Tabfile}`
trap 'chmod 440 ${Source}/${Tree};exit'1 2 3 4 5 6 7 8 9 15

dialogmsg "COMMIT 実行中"

echo "commit" > ${DiffDir}/lock/${SYSNAME}/${Target}/lkfile${Version}

cat ${DiffDir}/catlog >> ${DiffDir}/ver_${Version}/${SYSNAME}/${Target}/log_${VerTail}
errmsg ソースファイルのCOMMITの理由を記録してください。
vi ${DiffDir}/ver_${Version}/${SYSNAME}/${Target}/log_${VerTail}

cp -p ${Source}/${File} ${MainSource}/${SYSNAME}

popmsg "COMMIT が完了しました。新しいバージョンでなければ差分を登録出来ません。"

echo "${CMS_LOGNAME};${User};${File};${Version};${COMMIT_UPDATE}COMMIT" >> ${CommitLog}.${Version}
