#!/bin/ksh
# 
# fconv.ksh(0)
#
#
#
#  名称
#      fconv.ksh
#      
#  概要
#      漢字コード変換プログラムを実行する
#      
#  構文
#      fconv.ksh -e -s -u file-name
#      
#  説明
#      nkf の utf-8 前にファイルに対して実行した後元のファイル名に戻します。
#      本プログラムはシェルスクリプトです。
#
#	  -s はEUCに変換します。
#	  -u   UTF-8に変換します。
#      
#      
#  多言語化対応
#      
#      
#  診断
#      
#      
#  例
#      
#      
#  参照
#      sh(1),nkf(1)
#      
#  バグ
#      
#      
#  著者
#
#      
#  標準準拠
#      
#

PATH="$PATH:$HOME/bin:"
Tmpdir=/tmp
Tmpfile=fconv.ksh.$$
Option=
Target=

trap 'rm -f ${Tmpdir}/${Tmpfile};exit' 1 2 3 4 5 6 7 8 9 15

function _Usage
{
	print - Usage: fconv.sh [-e -u -s ] kanji-text-file;
	return 0;
}

if [ ! -d ${Tmpdir} ]
then
	exit 0
fi

#実行ファイルがパスに存在するか確かめる
whence nkf > /dev/null
if [ $? != 0 ]
then
	exit 0
fi
#whence ack > /dev/null
#if [ $? != 0 ]
#then
#	exit
#fi

case $# in
2)
	Option=$1
	Target=$2
;;
*) _Usage;exit 2;;
esac

test -w ${Target} || exit 2
fmode=`stat -c printf=%a ${Target} | sed 's/^printf=//'`

case $1 in
"-e")
	nkf -e  ${Target} > ${Tmpdir}/${Tmpfile}
;;
"-u")
	nkf -w80 -x --no-best-fit-chars ${Target} > ${Tmpdir}/${Tmpfile}
;;
"-s")
	nkf -s ${Target} > ${Tmpdir}/${Tmpfile}
;;
*) _Usage;exit 2;;
esac

if [ $? = 0 ]
then
	mv ${Tmpdir}/${Tmpfile} ${Target}
	chmod ${fmode} ${Target}
fi
exit 0
