#!/bin/ksh
#
#	LISTFILE.KSH
#	All Rights Reserved 1992 (C)
#
#	LISTFILE(21)             ＣＭＳ登録ファイルの表示
#
#
#	名前
#
#	　　listfile.ksh
#
#	使用法
#
#　　listfile
#
#	概要
#
#	　　　listfile はＣＭＳに登録されているソースファイルの一覧を表示します。
#	　　表示するファイル名はディレクトリ毎に対応します。
#	　　　get コマンドを使用して変更するソースファイルを呼び出す前に利用する
#	　　と良いでしょう。
#
#	関連項目
#	　　make(1) Makefile(1)
#	　　put(21) mr(21) get(21) report(21) verlock(21)
#	　　less(0) topic(0)

export PATH=".:$PATH:${CMSPATH}/bin"

DiffDir=${CMSPATH}/diff
MainDir=${CMSPATH}
SourceDir=${SYSNAME}/src

typeset -i count=0
CWD=`basename ${PWD}`
if [ x"$CWD" = x"$SYSNAME" ]
then
	#echo ${MainDir}/src/${SYSNAME}/[a-z]* #| more
	ls -1 ${MainDir}/src/${SYSNAME}/* | less
else
	ls -1 ${MainDir}/src/${SYSNAME}/${CWD}/* | less
fi

#typeset -i count=0
#CWD=`basename ${PWD}`
#if [ x"$CWD" = x"$SYSNAME" ]
#then
#	for i in `print - ${MainDir}/src/${SYSNAME}/[a-z]*`
#	do
#		if [ $count -eq 22 ]
#		then
#			echo "------ continue? -- [ y or n ] \c"
#			read dumy
#			if [ x"$dumy" = x"n" ]
#			then
#				exit
#			else
#				count=0
#				echo "\033[2J"
#			fi
#		fi
#		count=$count+1
#		basename ${i}
#	done
#else
#	for i in `print - ${MainDir}/src/${SYSNAME}/${CWD}/*.[a-z]*`
#	do
#		if [ $count -eq 22 ]
#		then
#			echo "------ continue? -- [ y or n ] \c"
#			read dumy
#			if [ x"$dumy" = x"n" ]
#			then
#				exit
#			else
#				count=0
#				echo "\033[2J"
#			fi
#		fi
#		count=$count+1
#		basename ${i}
#
#	done
#fi
