#!/bin/ksh
#
# manconv.ksh(0)
#
#
#  名称
#      manvonc.ksh
#      
#  概要
#      ＵＮＩＸマニュアルページの変換
#      
#  構文
#      manconv.ksh file-name
#      
#  説明
#      ＵＮＩＸのマニュアル表示に散在する不要なコード及び文字を削除する。
#      本プログラムはシェルスクリプトです。
#      
#      
#  多言語化対応
#      
#      
#  診断
#      
#      
#  例
#      
#      
#  参照
#      [7msh(1)[m, [7msed(1)[m, [7mman(1)[m
#      
#  バグ
#      
#  著者
#      manconv.ksh は Shigeki Ono によって開発されました。
#      
#  標準準拠
#      
#      
#      
#      
#      
#      
#      
#      
#      
#      
#      
#

export PATH=".:$PATH:${CMSPATH}/bin"

Tmpdir=/tmp
Tmpfile=fconv.ksh.$$
Option=
Target=

function _Usage
{
	print - Usage: manconv.ksh nroff-formating-file;
	return 0;
}

trap 'rm -f ${Tmpdir}/${Tmpfile};exit' 1 2 3 4 5 6 7 8 9 15

if [ ! -d ${Tmpdir} ]
then
	exit
fi

case $# in
1) Target=$2;;
*) _Usage;exit 2;;
esac

sed -e s/.//g -e s/_//g -e s///g ${Target} > ${Tmpdir}/${Tmpfile}

if [ $? = 0 ]
then
	mv ${Tmpdir}/${Tmpfile} ${Target}
fi
exit 0

