#!/bin/ksh
#
#	MKCMS2.KSH
#	All Rights Reserved 1991,92,99 (C)
#

export PATH=".:$PATH:${CMSPATH}/bin"

MainDir=${CMSPATH}/siten
SourceDir=${CMSPATH}/src
DiffDir=${CMSPATH}/diff
Tabfile=${CMSPATH}/diff/tabs/${TABFILE}
Version=${KEIVER}

if [ x${Tabfile} = x"" -o x${SYSNAME} = x"" -o x${KEIVER} = x"" ]
then
	errmsg "PC-CMS Environ for TABFILE SYSNAME KEIVER not found"
	exit
fi
BaseDir=`basename ${PWD}`
if [ x${BaseDir} != x${SYSNAME} ]
then
	errmsg "CMS のディレクトリがありません"
	exit
fi
if [ ! -f ${Tabfile} ]
then
	errmsg "CMS のテーブルファイルがカレントディレクトリに有りません"
	exit
fi
if [ ! -d ${DiffDir}/lock/${SYSNAME} ]
then
	#echo "mkdir2 ${DiffDir}/lock/${SYSNAME}"
	dialogmsg "mkdir2 ${DiffDir}/lock/${SYSNAME}"
	sleep 1
#	echo "\033[2J"
	mkdir2 ${DiffDir}/lock/${SYSNAME}
fi
for i in `cat -s ${Tabfile} | sed -f ${CMSPATH}/bin/suffixes.sed | sort -u`
do
	if [ ! -f ${DiffDir}/lock/${SYSNAME}/${i}/verfile.${KEIVER} ]
	then
		mkdir2 ${DiffDir}/lock/${SYSNAME}/${i}
		echo "${DiffDir}/lock/${SYSNAME}/${i}/verfile.${KEIVER}"
		echo "lock" > ${DiffDir}/lock/${SYSNAME}/${i}/lkfile${KEIVER}
		echo "${KEIVER}.00" > ${DiffDir}/lock/${SYSNAME}/${i}/verfile.${KEIVER}
		if [ ! -f ${DiffDir}/ver_${Version}/${SYSNAME}/${i}/${KEIVER}.00 ]
		then
			echo  "." > ${DiffDir}/ver_${Version}/${SYSNAME}/${i}/${KEIVER}.00
			echo  "w" >> ${DiffDir}/ver_${Version}/${SYSNAME}/${i}/${KEIVER}.00
		fi
	fi
done
