#!/bin/ksh
#
#	MRCSVOUT.KSH
#	All Rights Reserved 1992 (C)
#
#    MRCSVOUT(21)             機能追加及びファイル修正時の記録
#    
#    
#    名前
#    
#    
#    使用法
#    
#    
#    概要
#    
#    
#    関連項目
#    
#
#
#	著作
#		 Shigeki Ono 1999/7/7
#

export PATH=".:$PATH:${CMSPATH}/bin"

case $# in
4) ;;
*) errmsg "$# Usage: mrcsvout.ksh [ -a -s ] MR-number(000 - 999) user-name Version(1 - 9)"
exit ;;
esac

MainDir=${CMSPATH}
DiffDir=${CMSPATH}/diff
MrDir=${CMSPATH}/diff/mr
MrFile=mr
SysName=${SYSNAME}
EditCommand=${EDITOR}
CurentDir=`basename ${PWD}`

Opt=$1
MrNumber=$2
UserName=$3
Version=$4

case $Opt in
"-a"|"all") MrNumber="*" ;;
"-s") MrNumber=$2 ;;
no) ;;
esac

case $Opt in
"-s")
	grep -l "${MrNumber}" ${MrDir}/ver_${Version}/${SysName}/mrfiles > /dev/null
	if [ $? = 0 ]
	then
		echo  > ${MrDir}/ver_${Version}/${SysName}/${MrFile}_${MrNumber}.csv
		for j in `sed -n -f ${DiffDir}/mrcsv.sed ${MrDir}/ver_${Version}/${SysName}/${MrFile}.${MrNumber} | sed 's/^\[.*//' | sed '/^$/d'`
		do
			echo -e "${j},\c" >> ${MrDir}/ver_${Version}/${SysName}/${MrFile}_${MrNumber}.csv
		done
		echo >> ${MrDir}/ver_${Version}/${SysName}/${MrFile}_${MrNumber}.csv
		#sed -f ${MrDir}/ver_${Version}/${SysName}/${MrFile}_${MrNumber}
	else
		errmsg "${MrNumber} 番のＭＲは見つかりません．"
		exit
	fi
	;;
"-a")
	for i in `cat ${MrDir}/ver_${Version}/${SysName}/mrfiles`
	do
		#pg ${MrDir}/ver_${Version}/${SysName}/${MrFile}.${i}
		for j in `sed -n -f ${DiffDir}/mrcsv.sed ${MrDir}/ver_${Version}/${SysName}/${MrFile}.${i} | sed 's/^\[.*//' | sed '/^$/d'`
		do
			echo -e "${j},\c" >> ${MrDir}/ver_${Version}/${SysName}/${MrFile}_${MrNumber}.csv
		done
		echo >> ${MrDir}/ver_${Version}/${SysName}/${MrFile}_${i}.csv
	done
	;;
*) exit ;;
esac


