#!/bin/ksh
#
#	NEWFILE.KSH
#	All Rights Reserved 1992,99 (C)
#
#	NEWFILE(21)              新しいソースファイル登録
#
#
#	名前
#
#	　　newfile.ksh
#
#	使用法
#
#	　　newfile (source-file-name) (user-name) (version-number)
#
#	概要
#
#	　　　newfile はソースファイルを新しく作成し、ＣＭＳに登録するときだけ使
#	　　用します。newfile を使用するとき、カレントディレクトリに新しいソース
#	　　ファイルがなければなりません。登録が完了すると新しいソースファイルは
#	　　Ver1.0　としてＣＭＳに登録されます。登録されたファイルは getコマンド
#	　　によっていつでも呼出しが可能となります。
#
#	関連項目
#
#	　　make(1) Makefile(1)
#	　　put(21) vget(21) mr(21) report(21) listfile(21) verlock(21)

case $# in
3) ;;
*) errmsg "Usage: newfile (new-file) (user-name) (version(0 - 9))";exit ;;
esac

export PATH=".:$PATH:${CMSPATH}/bin"

File=$1
User=$2
Version=$3
Source=${CMSPATH}/src
MainSource=${CMSPATH}/siten
MakeDir=${CMSPATH}/fusr
Make=${CMSPATH}
NewLog=${CMSPATH}/diff/log/newlog
DiffDir=${CMSPATH}/diff
Tabfile=${CMSPATH}/diff/tabs/${TABFILE}
Userfile=${CMSPATH}/diff/userfile
NEW_CREATE=`date '+%Y/%m/%d,%H:%M'` 

if [ x"${SYSNAME}" = x"" -o x"${TABFILE}" = x"" ]
then
	errmsg "CMS 環境で必要な SYSNAME と TABFILE がセットされていません"
	exit
fi

Targetdir=`grep "^${File}$" ${Tabfile} | sed -f ${CMSPATH}/bin/suffixes.sed`
Targetfile=`grep "^${File}$" ${Tabfile}`
if [ x"${Targetfile}" = x"" ]
then
	Targetdir=`grep "\/${File}$" ${Tabfile} | sed -f ${CMSPATH}/bin/suffixes.sed`
	Targetfile=`grep "\/${File}$" ${Tabfile}`
	if [ x"${Targetfile}" = x"" ]
	then
		errmsg "${File} は ${TABFILE} に定義されていません"
		exit
	fi
fi

grep -l "${User}" ${Userfile} > /dev/null
if [ $? = 1 ]
then
	errmsg "${User} は CMS に登録されたユーザではありません"
	exit
fi
Mdir=`basename ${PWD} in`
if [ ! -f ${Targetfile} ]
then
	errmsg "$File が見つかりません"
	exit
fi
if [ ! -d ${DiffDir}/lock/${SYSNAME}/${Targetdir} ]
then
	if [ ! -d ${DiffDir}/ver_${Version}/${SYSNAME}/${Targetdir} ]
	then
		mkdir2 ${DiffDir}/ver_${Version}/${SYSNAME}/${Targetdir} > /dev/null
	fi
	mkdir2 ${DiffDir}/lock/${SYSNAME}/${Targetdir} > /dev/null
	echo "lock" > ${DiffDir}/lock/${SYSNAME}/${Targetdir}/lkfile${Version}
else
	popmsg "exit [y or n] : ${File} は CMS に登録されています。 "
	if [ $? = 0 ]
	then
		if [ ! -d ${DiffDir}/ver_${Version}/${SYSNAME}/${Targetdir} ]
		then
			mkdir2 ${DiffDir}/ver_${Version}/${SYSNAME}/${Targetdir} > /dev/null
		fi
	else
		exit
	fi
fi

if [ ! -f ${DiffDir}/lock/${SYSNAME}/${Targetdir}/verfile.${Version} ]
then
	echo "${Version}.00" > ${DiffDir}/lock/${SYSNAME}/${Targetdir}/verfile.${Version}
	Revision="00"
	echo "新規バージョン	${NEW_CREATE}" > ${DiffDir}/lock/${SYSNAME}/${Targetdir}/log_${Version}.${Revision}
	echo "lock" > ${DiffDir}/lock/${SYSNAME}/${Targetdir}/lkfile${Version}
fi
grep -l "${Version}.00" ${DiffDir}/lock/${SYSNAME}/${Targetdir}/verfile.${Version} > /dev/null
if [ $? = 1 ]
then
	echo "${Version}.00" >> ${DiffDir}/lock/${SYSNAME}/${Targetdir}/verfile.${Version}
	echo "." > ${DiffDir}/ver_${Version}/${SYSNAME}/${Targetdir}/${Version}.${Revision}
	echo "w" >> ${DiffDir}/ver_${Version}/${SYSNAME}/${Targetdir}/${Version}.${Revision}
fi
if [ ! -f ${DiffDir}/ver_${Version}/${SYSNAME}/${Targetdir}/${Version}.00 ]
then
	echo  "." > ${DiffDir}/ver_${Version}/${SYSNAME}/${Targetdir}/${KEIVER}.00
	echo  "w" >> ${DiffDir}/ver_${Version}/${SYSNAME}/${Targetdir}/${KEIVER}.00
fi

CurentDir=`basename ${PWD}`
BasePath=`grep "^${File}$" ${Tabfile}`
BaseDir=`unbasename ${BasePath}`
Endfile=`basename ${File}`
if [ x"${CurentDir}" = x"${SYSNAME}" ]
then
	diff -I "^#pragma ident" ${Targetfile} ${MainSource}/${CurentDir}/${BaseDir}${Endile} 1> /dev/null 2> /dev/null
	if [ $? = 2 ]
	then
		if [ ! -d ${MainSource}/${SYSNAME}/${BaseDir} ]
		then
			mkdir2 ${MainSource}/${SYSNAME}/${BaseDir} > /dev/null
		fi
		cp -p ${Targetfile} ${MainSource}/${SYSNAME}/${BaseDir}
	fi
	diff -I "^#pragma ident" ${Targetfile} ${Source}/${CurentDir}/${BaseDir}${Endfile} 1> /dev/null 2> /dev/null
	if [ $? = 2 ]
	then
		if [ ! -d ${Source}/${SYSNAME}/${BaseDir} ]
		then
			mkdir2 ${Source}/${SYSNAME}/${BaseDir} > /dev/null
		fi
		cp -p ${Targetfile} ${Source}/${SYSNAME}/${BaseDir}
	fi
fi
grep -l "${File}$" ${Tabfile} > /dev/null
if [ $? = 1 ]
then
	echo "${Targetfile}" >> ${Tabfile}
	exit
fi
