#!/bin/ksh
#
#	REJECT.KSH
#	All Rights Reserved 1992,99 (C)
#

export PATH=".:$PATH:${CMSPATH}/bin"

case $# in
4) ;;
*) errmsg "Usage: reject file-name user-name version-number(1-5) revision-number(01-99)"; exit ;;
esac

${CMSPATH}/bin/opcheck.ksh $1 $2 $3 $4
if [ $? = 1 ]
then
	errmsg "$1 $2 $3 $4"
	exit
fi

File=$1
User=$2
Version=$3
Revision=$4
SysName=${SYSNAME}
MainDir=${CMSPATH}
DiffDir=${CMSPATH}/diff
SourceDir=${CMSPATH}/src/${SYSNAME}
TmpFile=/tmp/_tmpfile
Tabfile=${CMSPATH}/diff/tabs/${TABFILE}
CurentDir=`basename ${PWD}`
Target=`echo ${File} | sed -f ${CMSPATH}/bin/suffixes.sed`
Ftree=`grep "^${File}$" ${Tabfile} | sed -f ${CMSPATH}/bin/suffixes.sed`
Tree=`grep "^${File}$" ${Tabfile}`

if [ x${Revision} = x"00" ]
then
	exit
fi

if [ x${Tree} = x"" ]
then
	errmsg "${File} がテーブルファイル内に見つかりません"
	exit
fi

grep -l "${Version}.${Revision}" \
${DiffDir}/lock/${SysName}/${Target}/verfile.${Version} > /dev/null
if [ $? = 1 ]
then
	errmsg "Version -  ${Version}.${Revision} 登録されていません"
	exit
fi
if [ -f ${DiffDir}/ver_${Version}/${SYSNAME}/${Tree} ]
then
	errmsg "ソースファイル: ${File} がありません"
	exit
fi
trap 'rm -f ${TmpFile};exit' 0 1 2 15
chmod 660 ${SourceDir}/${Tree} > /dev/null
rm -f ${DiffDir}/ver_${Version}/${SYSNAME}/${Ftree}/${Version}.${Revision}
rm -f ${DiffDir}/ver_${Version}/${SYSNAME}/${Ftree}/log_${Version}.${Revision}
sed '/^'${Version}\.${Revision}'$/d' \
${DiffDir}/lock/${SysName}/${Target}/verfile.${Version} > ${TmpFile}
mv ${TmpFile} ${DiffDir}/lock/${SysName}/${Target}/verfile.${Version} > /dev/null

grep -l "${Version}.00" ${DiffDir}/lock/${SysName}/${Target}/verfile.${Version} > /dev/null
if [ x"$?" = x"1" ]
then
	echo "${Version}.00" >> \
	${DiffDir}/ver_${Version}/${Ftree}/verfile.${Version} > /dev/null
fi

