#!/bin/ksh
#
#	MR.KSH
#	All Rights Reserved 1992 (C)
#
#	MR(21)                   機能追加及びファイル修正時の記録
#
#
#	名前
#
#	　　tr.ksh
#
#	使用法
#
#	　　tr (TR-number) (user-name) (version-number)
#
#	概要
#
#	　　　tr  はＣＭＳにおけるアプリケーション開発時の機能追加毎に発行する、
#	　　修正記録です。
#	　　　ＣＭＳでは開発者が修正時に記述する記録を、このＭＲ番号で管理します。
#	　    trは環境変数 EDITOR を参照して EDITOR の内容のエディタを呼び出しま
#	　　す。
#	　　　trの呼び出すファイルにはあらかじめ問題処理の為のフォーマットが登録
#	　　されていますので、内容を記述するだけになっています。
#	　　統一して記述することが出来ます。
#
#	関連項目
#
#	　　make(1) Makefile(1)
#	　　put(21) listfile(21) get(21) report(21) verlock(21)
#
#	著作
#	    tr.ksh は Shigeki Ono によって開発されました。
#

export PATH=".:$PATH:${CMSPATH}/bin"

dialogmsg "$1 $2 $3"
case $# in
3) ;;
*) errmsg "Usage: tr TR-number(001 - 999) (user-name) Version(0 - 9)";exit ;;
esac

TMPDIR=${CMSPATH}/tmp
MainDir=${CMSPATH}
DiffDir=${CMSPATH}/diff
TrDir=${CMSPATH}/diff/tr
TrFile=tr
EditCommand=${EDITOR}
CurentDir=`basename ${PWD}`
SysName=${SYSNAME}
TrNumber=$1
UserName=$2
Version=$3

if [ x"$EditCommand" = x"" ]
then
	EditCommand=vi
fi

trap 'rm -f ${TMPDIR}/tr_$$.tmp;exit 0' 1 2 3 4 5 6 7 8 9 15
if [ -f ${TrDir}/ver_${Version}/${SysName}/trfiles ]
then
	dialogmsg "trfiles が存在します"
else
	if [ ! -d ${TrDir}/ver_${Version}/${SysName} ]
	then
		mkdir2 ${TrDir}/ver_${Version}/${SysName}
	fi
	dialogmsg "trfiles を作成しています"
	echo >> ${TrDir}/ver_${Version}/${SysName}/trfiles
fi
grep -l "${TrNumber}" ${TrDir}/ver_${Version}/${SysName}/trfiles > /dev/null
if [ $? = 1 ]
then
	dialogmsg "TR番号を登録して終了します。"
	cat ${TrDir}/trformat > ${TrDir}/ver_${Version}/${SysName}/${TrFile}.${TrNumber}
	OWD=${PWD}
	cd ${TrDir}
	/bin/stty onlcr
	${EditCommand} ver_${Version}/${SysName}/${TrFile}.${TrNumber}
	popmsg "本当に登録しますか？ (Y or N)"
	case $? in
	1) chmod 660 ${TrDir}/ver_${Version}/${SysName}/trfiles > /dev/null
		echo "${TrNumber}" >> ${TrDir}/ver_${Version}/${SysName}/trfiles
	#	chmod 440 ${TrDir}/ver_${Version}/${SysName}/trfiles > /dev/null 
		sort -u ${TrDir}/ver_${Version}/${SysName}/trfiles > ${TMPDIR}/tr_$$.tmp
		mv ${TMPDIR}/tr_$$.tmp ${TrDir}/ver_${Version}/${SysName}/trfiles > /dev/null
		chmod 440 ${TrDir}/ver_${Version}/${SysName}/trfiles > /dev/null 
		cd ${OWD}
	;;
	*)	rm -f ${TrDir}/ver_${Version}/${SysName}/${TrFile}.${TrNumber}
		cd ${OWD}
		exit ;;
	esac
else
	cls
	errmsg "TR番号が重複しています。確認してください。"
	if [ $? = 0 ]
	then
		exit
	fi
fi
