#!/bin/ksh
#
#	MREDIT.KSH
#	All Rights Reserved 1992 (C)
#
#	TREDIT(21)               TRファイルの編集
#
#
#	名前
#
#	　　tredit.ksh
#
#	使用法
#
#	　　tredit (TR-number) (user-name) (version-number)
#
#
#	概要
#
#	　　　tredit　は環境変数 EDITOR を参照して EDITOR の内容のエディタを呼び
#	　　出します。
#	　　　エディタには vi か ed を選ぶことが出来ます。trの呼び出すファ
#	　　イルにはあらかじめ問題処理用のフォーマットが組んであり、統一して記述
#	　　することが出来ます。
#
#
#	関連項目
#
#	　　make(1) Makefile(1)
#	　　put(21) listfile(21) get(21) report(21) verlock(21) tr(21)

export PATH=".:$PATH:${CMSPATH}/bin"

case $# in
3) ;;
*) errmsg "Usage: tr TR-number(001 - 999) (user-name) Version(0 - 9)";exit;;
esac 
MainDir=${CMSPATH}
DiffDir=${CMSPATH}/diff
TrDir=${CMSPATH}/diff/tr
TrFile=tr
SysName=${SYSNAME}
EditCommand=$EDITOR
CurentDir=`basename ${PWD}`
TrNumber=$1
UserName=$2
Version=$3

if [ ! -f ${TrDir}/ver_${Version}/${SysName}/${TrFile}.${TrNumber} ]
then
	errmsg "TR Number: ${Version}.${TrNumber} は見つかりませんでした"
	exit
fi

if [ x"$EditCommand" = x"" ]
then
	EditCommand=vi
fi
OWD=${PWD}
#cd ${TrDir}

${EditCommand} ${TrDir}/ver_${Version}/${SysName}/${TrFile}.${TrNumber}


#inpmsg2 "２５５文字以内で入力してください" op
#echo $op > ${TrDir}/ver_${Version}/${SysName}/${TrFile}.${TrNumber}

#cd ${OWD}
