#!/bin/ksh
#
#	UNGET.KSH
#	All Rights Reserved 1992,99 (C)
#
#	UNGET(21)                 ソースファイルの呼出し中止
#	
#	名前
#	　　unget.ksh
#	
#	使用法
#	　　unget (source-file-name) (user-name) (version-number)
#	
#	概要

export PATH=".:$PATH:${CMSPATH}/bin"

case $# in
3) ;;
*) errmsg "Usage: unget (source-file) (user) (version(1 - 10))";exit ;;
esac

File=$1
User=$2
Version=$3
SysName=${SYSNAME}
Source=${CMSPATH}/src
Make=${CMSPATH}
GetLog=${CMSPATH}/diff/log/getlog
DiffDir=${CMSPATH}/diff
Tabfile=${CMSPATH}/diff/tabs/${TABFILE}
Userfile=${CMSPATH}/diff/userfile
Ffile=`echo ${File} | sed -f ${CMSPATH}/bin/suffixes.sed`
Endfile=`grep "^${File}$" ${Tabfile}`
UNGET_UPDATE=`date '+%Y/%m/%d,%H:%M'` 

if [ x"$SysName" = x"" ]
then
	exit
fi
grep -l "^$1$" ${Tabfile} > /dev/null
if [ $? = 1 ]
then
	errmsg "$1 is no file"
	exit
fi
grep -l "^$2$" ${Userfile} > /dev/null
if [ $? = 1 ]
then
	errmsg "$2 is no user"
	exit
fi
Mdir=`basename ${PWD}`
trap 'chmod 660 ${Source}/kei1/${file};exit 0' 1 2 3 4 5 6 7 8 9 15
if [ ! -f $File ]
then
	errmsg "$File は見つかりませんでした"
	exit
fi

grep -l "submit" ${DiffDir}/lock/${SYSNAME}/${Ffile}/lkfile${Version} > /dev/null
if [ $? = 0 ]
then
	op=`grep ${File} ${DiffDir}/log/getlog.${Version} | tail -1 | awk 'BEGIN {FS=";"}{print $1,"が",$4}'`
	errmsg "${File} は ${op} が submit（修正完了） しています"
	exit
fi

if [ ! -f ${DiffDir}/lock/${SysName}/${Ffile}/verfile.${Version} ]
then
echo "${Version}.00" > ${DiffDir}/lock/${SysName}/${Ffile}/verfile.${Version}
fi
grep -l "${Version}.00" ${DiffDir}/lock/${SysName}/${Ffile}/verfile.${Version} > /dev/null
if [ x"$?" = x"1" ]
then
	echo "${Version}.00" >> ${DiffDir}/lock/${SysName}/${Ffile}/verfile.${Version}
fi

${CMSPATH}/bin/verlock.ksh -r ${File} ${Version}
chmod 660 ${Source}/${SYSNAME}/${Endfile} > /dev/null

echo "${CMS_LOGNAME};${User};${File};${Version};${UNGET_UPDATE};UNGET" >>${GetLog}.${Version}
#${CMSPATH}/bin/mkver.ksh -p ${File} ${Version}

popmsg "${File} ファイルを削除しますか？ (Y or N)"
case $? in
1)
	rm -f ${File}
	;;
*)
;;
esac
