#pragma ident "@(#) filertool.cc 1.0.9 2010.05.24,10:34"
/*
	名前
		filertool.cc

	機能

	1) パスワードファイルからuserid groupidを読み取る
	2) 環境変数のセット
	3) ブックマークの表示と保存

	All Rights Reserved 1996(C) Shigeki.Ono
*/

#include "ftx.h"
#include "filer.h"

static DIR *dir;

char tmp[80];

/************************************************************************/
/* NAME      :popmsg() デバッグ用*/
/* FUNCTION  :int x*/ 
/*            int y*/ 
/*            char *buff*/ 
/*            */ 
/* RETURN    : Y:1 N:0*/
/************************************************************************/
int FilerTool::popmsg(int x,int y,const std::string  Message)
{
	WINDOW *pvs;
	int i;
	int ch;

	pvs = newwin(6,68,y,x);
	box(pvs,ACS_VLINE,ACS_HLINE);
	noecho();
	for(;;)
	{
		wattron(pvs,A_REVERSE);
		mvwprintw(pvs,0,1,"============ Debug Window Message ============");
		wattroff(pvs,A_REVERSE);
		mvwprintw(pvs,0,0,"+");
		mvwprintw(pvs,0,47,"+");
		mvwprintw(pvs,5,0,"+");
		mvwprintw(pvs,5,47,"+");

		mvwprintw(pvs,2,4,"%s",Message.c_str());
		mvwprintw(pvs,4,30,"Y or N :");
		wrefresh(pvs);
		ch = wgetch(pvs);
		switch(ch)
		{
		case 'y': case 'Y':
			delwin(pvs);
			return(1);
		case 'n': case 'N':
			delwin(pvs);
			return(0);
		}
	}
}

/************************************************************************/
/* NAME      :*/
/* FUNCTION  :*/ 
/*            */ 
/*            */ 
/*            */ 
/* RETURN    :*/
/************************************************************************/
int FilerTool::bookmarksave(void)
{
	FILE *fp;
	int i=0,j,x;
	int ch;
	char *nwl;
	int line = 0;
	unsigned long c = 0L;
//	char buff[1024];
	char *sp;
	char bp[256];
	char filename[256];
	char *cret;

	if((sp = getenv("HOME")) == NULL)
	{
		return(-1);
	}
	else
	{
#ifdef CYGWIN
		cret = getcwd(bp,256);
		if(!strncmp(bp,"/cygdrive/",10))
		{
			sprintf(filename,"/cygdrive/c/cygwin%s/%s",sp,".bookmark.cw");
		}
		else
		{
			sprintf(filename,"%s/%s",sp,".bookmark.cw");
		}
#else
		sprintf(filename,"%s/%s",sp,".bookmark.cw");
#endif
	}

	if((fp = fopen(filename,"w")) == (FILE *)NULL)
	{
		return(-1);
	}

	while(bookmarks[line][0] != '\0')
	{
		fprintf(fp,"%s\n",bookmarks[line]);
		line++;
	}
	bookline = line;
	fclose(fp);
	return(0);
}


/************************************************************************/
/* NAME      :void bookmark()*/
/* FUNCTION  :bookmark のメインルーチン*/ 
/*            */ 
/*            */ 
/*            */ 
/* RETURN    :なし*/
/************************************************************************/
void FilerTool::bookmark(void)
{
	FILE *fp;
	int i=0,j,x;
	int ch;
	char *nwl;
	int line = 0;
	unsigned long c = 0L;
//	char buff[1024 + 1];
	char buff[256];
	char *sp;
	char filename[256];

	if((sp = getenv("HOME")) == NULL)
	{
		printf("HOME value not fuond.\n");
		getch();
	}
	else
	{
		sprintf(filename,"%s/%s",sp,".bookmark.cw");
	}

	if((fp = fopen(filename,"r")) == (FILE *)NULL)
	{
		for(i=0;i<256;i++)
		{
			memset(bookmarks[i],'\0',sizeof(char)*256);
		}
		return;
	}

//	while(fgets(buff,1024,fp) != NULL)
	while(fgets(buff,256,fp) != NULL)
	{
		if((nwl = strchr(buff,'\n')) != (char *)NULL)
		{
			*nwl = '\0';
		}
		sprintf(bookmarks[line],"%s",buff);
		line++;
	}
	bookline = line;
	fclose(fp);
}

/************************************************************************/
/* NAME      :*/
/* FUNCTION  :*/ 
/*            */ 
/*            */ 
/*            */ 
/* RETURN    :*/
/************************************************************************/
void FilerTool::cutfspace(char *s)
{
	int i,j;
	int len;
	char t[256];

	len = strlen(s);
	for(i=0;i < len;i++)
	{
		if(s[i] != ' ')
			break;
			else if (s[i] == '\t')
				break;
	}
	for(j=0;i < len;i++,j++)
	{
		t[j] = s[i];
	}
	t[j] = '\0';
	sprintf(s,"%s",t);
}

/************************************************************************/
/* NAME      :*/
/* FUNCTION  :*/ 
/*            */ 
/*            */ 
/*            */ 
/* RETURN    :*/
/************************************************************************/
void FilerTool::readowner(void)
{
	FILE *fp;
	int i;
	int n = 0;
	char buff[256];
	char *nwl;

	if((fp = fopen("/etc/passwd","rb")) == NULL)
	{
		return;
	}

	while(fgets(buff,256,fp) != NULL)
	{
		if((nwl = strchr(buff,'\n')) != NULL)
		{
			if(n > 255)
			{
				fclose(fp);
				return;
			}
			nwl = '\0';
			passread(buff,n);
			n++;
		}
	}
	fclose(fp);
}

/************************************************************************/
/* NAME      :*/
/* FUNCTION  :*/ 
/*            */ 
/*            */ 
/*            */ 
/* RETURN    :*/
/************************************************************************/
void FilerTool::readgroup(void)
{
	FILE *fp;
	int i;
	int n = 0;
	char buff[256];
	char *nwl;
	if((fp = fopen("/etc/group","rb")) == NULL)
	{
		return;
	}

	while(fgets(buff,256,fp) != NULL)
	{
		if((nwl = strchr(buff,'\n')) != NULL)
		{
			if(n > 255)
			{
				fclose(fp);
				return;
			}
			nwl = '\0';
			groupread(buff,n);
			n++;
		}
	}
	fclose(fp);
}

/************************************************************************/
/* NAME      :*/
/* FUNCTION  :*/ 
/*            */ 
/*            */ 
/*            */ 
/* RETURN    :*/
/************************************************************************/
void FilerTool::passread(char *path,int n)
{
	int i,j;
	int len;
	int cnt;
	char buff[256];

	cnt = 0;
	len = strlen(path);
	for(i=0,j=0;i<len;i++)
	{
		switch(path[i])
		{
		case ':':
			buff[j] = '\0';
			switch(cnt)
			{
			case 0:
				if(strlen(buff) > (size_t)9)
					buff[8] = '\0';
				sprintf(username[n],"%s",buff);
				break;
			case 2:
				if(strlen(buff) > (size_t)6)
					buff[6] = '\0';
				sprintf(userid[n],"%s",buff);
				break;
			case 3:
				if(strlen(buff) > (size_t)6)
					buff[6] = '\0';
				sprintf(groupid[n],"%s",buff);
				break;
			}
			cnt++;
			j = 0;
			break;
		default:
			buff[j] = path[i];
			j++;
			break;
		}
	}
	sprintf(path,"%s",buff);
}

/************************************************************************/
/* NAME      :*/
/* FUNCTION  :*/ 
/*            */ 
/*            */ 
/*            */ 
/* RETURN    :*/
/************************************************************************/
void FilerTool::groupread(char *path,int n)
{
	int i,j;
	int len;
	int cnt;
	char buff[256];

	cnt = 0;
	len = strlen(path);
	for(i=0,j=0;i<len;i++)
	{
		switch(path[i])
		{
		case ':':
			buff[j] = '\0';
			switch(cnt)
			{
			case 0:
				if(strlen(buff) > (size_t)9)
					buff[8] = '\0';
				sprintf(groupname[n],"%s",buff);
				break;
			case 2:
				if(strlen(buff) > (size_t)6)
					buff[6] = '\0';
				sprintf(groupid[n],"%s",buff);
				break;
			case 3:
				break;
			}
			cnt++;
			j = 0;
			break;
		default:
			buff[j] = path[i];
			j++;
			break;
		}
	}
	sprintf(path,"%s",buff);
}

/************************************************************************/
/* NAME      :*/
/* FUNCTION  :*/ 
/*            */ 
/*            */ 
/*            */ 
/* RETURN    :*/
/************************************************************************/
void FilerTool::pathfiled(char *path,int n)
{
	int i,j,k;
	int len;
	char buff[1025];
	char pathbuff[256];

	len = strlen(path);
	for(i=0,j=0,k=0;i<len;i++)
	{
		switch(path[i])
		{
		case '\\':
			i++;
			break;
		case ':': case '\n':
			buff[j] = '\0';
			sprintf(pathbuff,"%s",buff);
			getdirfile(pathbuff);
			j = 0;
		default:
			buff[j] = path[i];
			j++;
			break;
		}
	}
	sprintf(path,"%s",buff);
}

/************************************************************************/
/* NAME      :*/
/* FUNCTION  :*/ 
/*            */ 
/*            */ 
/*            */ 
/* RETURN    :*/
/************************************************************************/
void FilerTool::getdirfile(char *pathbuff)
{
	struct dirent *dp;
	int i=0;
	int j=0;
	int k=0;
	int len;
	struct tm *ftm;

	if((dir = opendir(pathbuff)) == (DIR *)NULL)
		exit(1);
	while((dp = readdir(dir)) != (struct dirent *)NULL)
	{
		stat(dp->d_name,fptr);
		if(!S_ISDIR(fptr->st_mode))
		{
			sprintf(openbuff[i],"%s",dp->d_name);
			i++;
		}

	}
	closedir(dir);
}

/************************************************************************/
/* NAME      :*/
/* FUNCTION  :*/ 
/*            */ 
/*            */ 
/*            */ 
/* RETURN    :*/
/************************************************************************/
void FilerTool::_splitpath(char *path,char *dir,char *file)
{
	int i,j=0,k,l,len;
	int cn=0;
	len = strlen(path);
	for(i=0;i<len;i++)
	{
		if(path[i] == '/')
			cn++;
	}
	for(i=0;i<len;i++)
	{
		switch(path[i])
		{
		case '/':
			j++;
			if(j == cn)
			{
				strncpy(dir,path,i);
				for(k=i+1,l=0;k<len;k++,l++)
					file[l] = path[k];
				file[l] = '\0';
			}
			break;
		}
	}
}

/************************************************************************/
/* NAME      :int bookmarkmenu()*/ 
/* FUNCTION  :ブックマークメニューを表示する*/ 
/*            */ 
/*int x;	表示桁位置*/
/*int y;	表示行位置*/
/*char *buff;	表示するメッセージ*/
/*            */ 
/*            */ 
/* RETURN    :メニューのFILE*/


/************************************************************************/
char *FilerTool::bookmarkmenu(int x,int y,char *buff)
{
	WINDOW *pvs;
	int ch;
	int item = 1;
	int x2;
	int i;
	int j = curline;
	int yy = displine;
	int ylen = 22;
	char copybuff[512];
	char tmpbuff[1024];
	int ret;

	pvs = newwin(23,79,y,x);
	wattron(pvs,A_REVERSE);
	box(pvs,' ',' ');
	wattroff(pvs,A_REVERSE);

	for(;;)
	{
		wattron(pvs,A_REVERSE);
		for(i=0;i<ylen-1;i++)
		{
			memset(gwpmenu[i],' ',256);
			mvwprintw(pvs,i+1,0,"%s",gwpmenu[i]);
			sprintf(gwpmenu[i],"%2d %s",i+1+yy,bookmarks[i+yy]);
			mvwprintw(pvs,i+1,1,"%s",gwpmenu[i]);
		}
		wattroff(pvs,A_REVERSE);

		wmove(pvs,j+1,2);
		wattroff(pvs,A_REVERSE);
		mvwprintw(pvs,j+1,1,"%s",gwpmenu[j]);
		wattron(pvs,A_REVERSE);

		wrefresh(pvs);
        ch = wgetch(pvs);
        getyx(pvs,item,x2);

        switch(ch)
        {
		case 'P':
			sprintf(tmpbuff,"%s:%d",gwpmenu[j],bookline);
			popmsg(1,10,tmpbuff);
			break;

		case 'j': case 0x42:
			if(j + yy >= bookline - 1 || j + yy > 256 + 1)
				break;
			if(yy > bookline)
				break;
			if(j > ylen - 3)
			{
				yy++;
				break;
			}
			if(j <= ylen - 3 && (bookline-1) > j)
			{
				j++;
			}
			break;

        case 'k': case 0x41:
            if(j == 0 &&  yy > 0)
            {
                yy--;
                break;
            }
			j--;
			if(j < 0)
				j = 0;
            break;
		case 't': case 'T':
			j =0;
			yy = 0;
			break;
		case 'g': case 'G':
			if(bookline < ylen)
			{
				j = bookline - 1;
				break;
			}
			if(j + yy > bookline)
				break;
			j = ylen - 3;
			yy = (bookline - ylen)+2;
			break;

	case 'p':
//	ファイルをコピーする。

	loop1:

	stat(buff,fptr);
	if((S_ISDIR(fptr->st_mode)) != 0)
	{
		sprintf(tmpbuff,"%s はディレクトリです。bookmarkメニューからはコピー出来ません",buff);
		popmsg(4,10,tmpbuff);
		return(0);
	}
	//2013.3.6 BUG
	sprintf(copybuff,"%s",bookmarks[j+yy]);
	//sprintf(copybuff,"%s",bookmarks[(item+yy)-1]);
	if(strlen(copybuff) < (size_t)1)
		return(0);
	sprintf(tmpbuff,"cp -p %s -> %s",buff,copybuff);
	if(popmsg(2+8,(24/2)-4,tmpbuff) == 1)
	{
		stat(copybuff,fptr);
		if((fptr->st_mode & S_IFDIR) != 0)
		{
			stat(copybuff,fptr);
			if((fptr->st_mode & (S_IWOTH | S_IWGRP | S_IWUSR)) != 0)
			{
				sprintf(tmpbuff,"%s/%s",copybuff,buff);
				stat(tmpbuff,fptr);
				if((fptr->st_mode & S_IFREG) != 0)
				{
					if(popmsg(2+8,(24/2)-4,"同名のファイルが存在します。上書きしますか？") == 1)
					{
						sprintf(tmpbuff,"cp -p %s %s > /dev/null 2>&1",buff,copybuff);
						ret = system(tmpbuff);
					}
					return(0);
				}
				sprintf(tmpbuff,"cp -p %s %s > /dev/null 2>&1",buff,copybuff);
				ret = system(tmpbuff);

			}
			else
			{
				sprintf(tmpbuff,"%s に書き込み権限がありません。",copybuff);
				popmsg(4,10,tmpbuff);
			}
		}
		else
		{
			sprintf(tmpbuff,"%s が見つかりません",copybuff);
			popmsg(4,10,tmpbuff);
			goto loop1;
		}
	}
			break;

		case 0x0d: case 0x0a: case'Z': case 'c':
			displine = yy;
			curline = j;
			delwin(pvs);
		//popmsg(1,10,bookmarks[j]);
		//sprintf(tmpbuff,"%s:%d",bookmarks[j+yy],j+yy);
		//popmsg(1,10,tmpbuff);
			return(bookmarks[j+yy]);
		case 'v':
			break;
		case 'q':
			displine = yy;
			curline = j;
			delwin(pvs);
			return((char *)NULL);
		defualt:
			break;
		}
	}
}

