#pragma ident "@(#) ftx.cc 1.1.1 2012.05.04,22:32"
#include "ftx.h"

//以下のインスタンス名は本ライブラリで固定されている。
//ファイラーのためのリストボックスクラス
extern ListBox *pFilerListBox;
//ホスト、ユーザ、パスワードを管理するリストボックスクラス
extern ListBox *pListBox;
//FTPとの応答を記録するリストボックスクラス（詳細情報）
extern ListBox *ImmLog;
//FTPのLIST受信ファイルを読み取るクラス
extern OpenFileListBox *ftp;

void FTPConnect(void);
void FTPSelect(void);

int RemoveTmpDir(void)
{
	//FTPファイラー情報を保存したファイルを削除する。
	unlink(pFilerListBox->txtTmpDirListFile);
	//FTPファイラー情報を保存したディレクトリを削除する。
	rmdir(pFilerListBox->txtEditDir);
	endwin();
	return(0);
}


int main(void)
{
//	signal(SIGINT,(int)RemoveTmpDir);
	signal(SIGPIPE,SIG_IGN);
//	signal(SIGSEGV,SIG_IGN);
	signal(SIGQUIT,SIG_IGN);

	//ncursesのロケールを設定する。
	setlocale(LC_ALL,"");

	//ncursesの開始
	initscr();
	cbreak();
	noecho();

	//FTP接続開始と全ての操作を行う。
	FTPConnect();

	//ncursesを終了
	endwin();
	printf("\033[2J");
}

void FTPConnect(void)
{
	u_int intServerReplyCode;
	char *strCommand;
	char *result;
	int intResultLocation;
	
	int ret;

	//ファイラー階層初期化のためのクラス
	pFilerListBox = new ListBox();

	//FTPファイラーの情報（LIST -aL）を保存するディレクトリを設定
	pFilerListBox->setTmpDir();

	//ホスト接続用リストボックス作成
	pListBox = new ListBox();

	pListBox->height = 5;
	pListBox->width = 90;
	pListBox->sx = 0;
	pListBox->sy = 4;
	sprintf(pListBox->title,"%s","Hostname");

	pListBox->line = 0;
	pListBox->cursol = 0;

	//接続情報監視のためのリストボックス作成（詳細情報）
	ImmLog = new ListBox();

	ImmLog->height = 5;
	ImmLog->width = 90;
	ImmLog->sx = 0;
	ImmLog->sy = 4;
	ImmLog->line = -1;
	ImmLog->cursol = -1;

	//FTPファイラーのためのリストボックス作成
	ftp = new OpenFileListBox();

	ftp->height = LINES - 10;
	ftp->width = 90;
	ftp->sx = 0;
	ftp->sy = 9;

	while((pListBox->popmsg(1,0,"ホストコンピュータと接続を開始します")))
	{
		pListBox->Clear();
		// /home/cms/etc/passwd.ftx ファイルよりホスト設定情報を読み取る。
		pFilerListBox->readHostSetFile();
		//リストボックスで選択した結果はホスト名とユーザID
		result = pListBox->Listbox();
		//結果がNULLの場合は終了する。Listbox()で'q'で終了の場合。2010.03.29追加
		if(!result)
			return;
		// : で区切られた結果からホスト名だけを抜き取る。
		intResultLocation = pFilerListBox->InStr(1,result,':');
		sprintf(pFilerListBox->txtHostName,"%s",pFilerListBox->Left(result,intResultLocation));
		//FTP接続経過情報リストボックスのタイトルにホスト名を入れる。
		sprintf(ImmLog->title,"%s",pFilerListBox->txtHostName);
		if (strlen(pFilerListBox->txtHostName) == 0)
		{
			pListBox->MsgBox("ホストコンピュータ名の入力がありません");
			RemoveTmpDir();
			return;
		}
		//残りのホスト情報（userID,Password,HomeDir）をリストボックスクラスのメンバ変数に保存する。
		sprintf(pFilerListBox->txtUserID,"%s",pFilerListBox->pf[pListBox->index].userid);
		sprintf(pFilerListBox->txtPassword,"%s",pFilerListBox->pf[pListBox->index].passwd);
		sprintf(pFilerListBox->txtHomeDir,"%s",pFilerListBox->pf[pListBox->index].homedir);
		sprintf(pFilerListBox->txtOPTL,"%s",pFilerListBox->pf[pListBox->index].OPTL);
		pFilerListBox->intTYPE = pFilerListBox->pf[pListBox->index].TYPE;
		pFilerListBox->intPASV = pFilerListBox->pf[pListBox->index].PASV;
		pFilerListBox->intWAIT = pFilerListBox->pf[pListBox->index].WAIT;
		sprintf(pFilerListBox->txtEditor,"%s",pFilerListBox->pf[pListBox->index].editor);
		sprintf(pFilerListBox->txtViewer,"%s",pFilerListBox->pf[pListBox->index].viewer);
		sprintf(pFilerListBox->txtBrowser,"%s",pFilerListBox->pf[pListBox->index].browser);

		if (strlen(pFilerListBox->txtUserID) == 0)
		{
			pListBox->MsgBox("ログオンユーザ名の入力がありません");
			RemoveTmpDir();
			return;
		}
		if (strlen(pFilerListBox->txtPassword) == 0)
		{
			pListBox->MsgBox("パスワードの入力がありません");
			RemoveTmpDir();
			return;
		}
		if (strlen(pFilerListBox->txtHomeDir) == 0)
		{
			pListBox->MsgBox("初期ディレクトリの入力がありません");
			RemoveTmpDir();
			return;
		}
		//ホストへ最初の接続
		pFilerListBox->intDoFirstConnect();

		//ファイラーリストボックスの初期化（ディレクトリの階層化情報）
		pFilerListBox->InitCursol(0);
		pFilerListBox->deep = 0;

		//FTPファイラーを実行する。
		pFilerListBox->ftx();
	}

	//FTPファイラー情報を保存したファイルを削除する。
	unlink(pFilerListBox->txtTmpDirListFile);
	//FTPファイラー情報を保存したディレクトリを削除する。
	rmdir(pFilerListBox->txtEditDir);

	//全てのメモリを開放する。
	delete pFilerListBox;
	delete pListBox;
	delete ImmLog;

	//終了する。
	return;
}

void FTPSelect(void)
{
	u_int intServerReplyCode;
	char *strCommand;
	char *result;
	int intResultLocation;
	
	int ret;

	while((pListBox->popmsg(1,0,"ホストコンピュータと接続を開始します")))
	{
		pListBox->Clear();
		// /home/cms/etc/passwd.ftx ファイルよりホスト設定情報を読み取る。
		pFilerListBox->readHostSetFile();
		//リストボックスで選択した結果はホスト名とユーザID
		result = pListBox->Listbox();
		// : で区切られた結果からホスト名だけを抜き取る。
		intResultLocation = pFilerListBox->InStr(1,result,':');
		sprintf(pFilerListBox->txtHostName,"%s",pFilerListBox->Left(result,intResultLocation));
		//FTP接続経過情報リストボックスのタイトルにホスト名を入れる。
		sprintf(ImmLog->title,"%s",pFilerListBox->txtHostName);
		if (strlen(pFilerListBox->txtHostName) == 0)
		{
			pListBox->MsgBox("ホストコンピュータ名の入力がありません");
			RemoveTmpDir();
			return;
		}
		//残りのホスト情報（userID,Password,HomeDir）をリストボックスクラスのメンバ変数に保存する。
		sprintf(pFilerListBox->txtUserID,"%s",pFilerListBox->pf[pListBox->index].userid);
		sprintf(pFilerListBox->txtPassword,"%s",pFilerListBox->pf[pListBox->index].passwd);
		sprintf(pFilerListBox->txtHomeDir,"%s",pFilerListBox->pf[pListBox->index].homedir);
		sprintf(pFilerListBox->txtOPTL,"%s",pFilerListBox->pf[pListBox->index].OPTL);
		pFilerListBox->intTYPE = pFilerListBox->pf[pListBox->index].TYPE;
		pFilerListBox->intPASV = pFilerListBox->pf[pListBox->index].PASV;
		pFilerListBox->intWAIT = pFilerListBox->pf[pListBox->index].WAIT;
		sprintf(pFilerListBox->txtEditor,"%s",pFilerListBox->pf[pListBox->index].editor);
		sprintf(pFilerListBox->txtViewer,"%s",pFilerListBox->pf[pListBox->index].viewer);
		sprintf(pFilerListBox->txtBrowser,"%s",pFilerListBox->pf[pListBox->index].browser);

		if (strlen(pFilerListBox->txtUserID) == 0)
		{
			pListBox->MsgBox("ログオンユーザ名の入力がありません");
			RemoveTmpDir();
			return;
		}
		if (strlen(pFilerListBox->txtPassword) == 0)
		{
			pListBox->MsgBox("パスワードの入力がありません");
			RemoveTmpDir();
			return;
		}
		if (strlen(pFilerListBox->txtHomeDir) == 0)
		{
			pListBox->MsgBox("初期ディレクトリの入力がありません");
			RemoveTmpDir();
			return;
		}
		//ホストへ最初の接続
		pFilerListBox->intDoFirstConnect();

		//ファイラーリストボックスの初期化（ディレクトリの階層化情報）
		pFilerListBox->InitCursol(0);
		pFilerListBox->deep = 0;

		//FTPファイラーを実行する。
		pFilerListBox->ftx();
	}

	//FTPファイラー情報を保存したファイルを削除する。
	unlink(pFilerListBox->txtTmpDirListFile);
	//FTPファイラー情報を保存したディレクトリを削除する。
	rmdir(pFilerListBox->txtEditDir);
//	RemoveTmpDir();

	//全てのメモリを開放する。
	delete pFilerListBox;
	delete pListBox;
	delete ImmLog;
	delete ftp;

	//終了する。
	return;
}

