/***************************************************************************
 *            cxp-gui.c
 *
 *  Fri Jan 21 23:10:22 2005
 *  Copyright  2005  Yasumichi Akahoshi
 *  yasumichi@users.sourceforge.jp
 ****************************************************************************/

/*
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
 
#include "cxp-gui.h"

/**
 * This displays the dialog which demands an input from a user, and returns 
 * the string which the user inputted.
 * @param owner [in] Parent of dialog.
 * @param title [in] Title of dialog.
 * @param defval [in] default value of text entry.
 * @return String was inputed by user. When user don't input or clicked cancel,
 * NULL is returned.
 */
gchar *cxp_input_box (GtkWindow * owner, const gchar * title,const gchar * defval)
{
	gchar *inputed;
	GtkWidget *dialog;
	GtkWidget *entry;

	dialog = gtk_dialog_new_with_buttons (title, owner,
					      GTK_DIALOG_DESTROY_WITH_PARENT,
					      GTK_STOCK_CANCEL,
					      GTK_RESPONSE_CANCEL,
					      GTK_STOCK_OK, GTK_RESPONSE_OK,
					      NULL);
	gtk_dialog_set_default_response (GTK_DIALOG (dialog), GTK_RESPONSE_OK);
	entry = gtk_entry_new ();
	gtk_entry_set_text (GTK_ENTRY(entry), defval);
	gtk_widget_show (entry);
	gtk_container_add (GTK_CONTAINER (GTK_DIALOG (dialog)->vbox), entry);
	if (gtk_dialog_run (GTK_DIALOG (dialog)) == GTK_RESPONSE_OK)
	{
		inputed = g_strdup (gtk_entry_get_text (GTK_ENTRY (entry)));
		if (strlen (inputed) == 0)
		{
			g_free (inputed);
			inputed = NULL;
		}
	}
	else
	{
		inputed = NULL;
	}
	gtk_widget_destroy (dialog);

	return inputed;
}
