/***************************************************************************
 *            cxp-utils.c
 *
 *  Fri Jan 21 23:10:34 2005
 *  Copyright  2005  Yasumichi Akahoshi
 *  yasumichi@users.sourceforge.jp
 ****************************************************************************/

/*
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
 
 #include <cxp-utils.h>
 
 /**
 * Gets the last component of the filename converted to UTF-8. If file_name ends
 * with a directory separator it gets the component before the last slash. If 
 * file_name consists only of directory separators (and on Windows, possibly a
 * drive letter), a single separator is returned. If file_name is empty, it gets
 * ".".
 * @param file_name  the name of the file.
 * @return a newly allocated string containing the last component of the
 * filename converted from locale to UTF-8.
 */
gchar *cxp_path_get_basename_of_utf8 (const gchar * file_name)
{
	gchar *gcBasenameLocale;
	gchar *gcBasenameUtf8;

	gcBasenameLocale = g_path_get_basename (file_name);
	gcBasenameUtf8 =
		g_locale_to_utf8 (gcBasenameLocale, -1, NULL, NULL, NULL);
	g_free (gcBasenameLocale);

	return gcBasenameUtf8;
}

/**
 * Gets the directory components of a file name converted to UTF-8. If the file 
 * name has no directory components "." is returned. The returned string should
 * be freed when no longer needed.
 * @param file_name	the name of the file.
 * @return the directory components of the file converted from locale to UTF-8.
 */
gchar *cxp_path_get_dirname_of_utf8 (const gchar * file_name)
{
	gchar *gcDirnameLocale;
	gchar *gcDirnameUtf8;

	gcDirnameLocale = g_path_get_dirname (file_name);
	gcDirnameUtf8 =
		g_locale_to_utf8 (gcDirnameLocale, -1, NULL, NULL, NULL);
	g_free (gcDirnameLocale);

	return gcDirnameUtf8;
}
