/***************************************************************************
 *            cxp-entry-dialog.h
 *
 *  Sun Feb 13 23:49:57 2005
 *  Copyright  2005  Yasumichi Akahoshi
 *  yasumichi@users.sourceforge.jp
 ****************************************************************************/

/*
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
 

#ifndef CXP_ENTRY_DIALOG_H
#define CXP_ENTRY_DIALOG_H

/*
 * Potentially, include other headers on which this header depends.
 */
#include <gtk/gtk.h>
#include <glib-object.h>

#define CXP_TYPE_ENTRY_DIALOG		  (cxp_entry_dialog_get_type ())
#define CXP_ENTRY_DIALOG(obj)		  (G_TYPE_CHECK_INSTANCE_CAST ((obj), CXP_TYPE_ENTRY_DIALOG, CxpEntryDialog))
#define CXP_ENTRY_DIALOG_CLASS(klass)	  (G_TYPE_CHECK_CLASS_CAST ((klass), CXP_TYPE_ENTRY_DIALOG, CxpEntryDialogClass))
#define CXP_IS_ENTRY_DIALOG(obj)	  (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CXP_TYPE_ENTRY_DIALOG))
#define CXP_IS_ENTRY_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CXP_TYPE_ENTRY_DIALOG))
#define CXP_ENTRY_DIALOG_GET_CLASS(obj)  (G_TYPE_INSTANCE_GET_CLASS ((obj), CXP_TYPE_ENTRY_DIALOG, CxpEntryDialogClass))

typedef struct _CxpEntryDialog CxpEntryDialog;
typedef struct _CxpEntryDialogClass CxpEntryDialogClass;

struct _CxpEntryDialog {
	GtkDialog parent;
};

struct _CxpEntryDialogClass {
	GtkDialogClass parent;
};

/* used by CXP_TYPE_ENTRY_DIALOG */
GType cxp_entry_dialog_get_type (void);

/* API. */

#endif /* CXP_ENTRY_DIALOG_H */
GtkWidget *cxp_entry_dialog_new(const gchar *title, const gchar *message, const gchar *entry_text);
gchar *cxp_entry_dialog_get_entry_text(CxpEntryDialog *dialog);
