/* $Id: cxp-profile.h,v 1.6 2005/04/16 15:15:19 yasumichi Exp $ */
/**
 * \if japanese
 * @file
 * @brief ե
 *
 * եɤ߽񤭤ͤμȥåȤԤϡ
 * ե ~/.cxp/ץꥱ̾/̾ ¸ޤ
 * @author 
 * @date Fri Jan 21 2005
 * $Revision: 1.6 $
 * \endif
 * \if english
 * @file
 * @brief Operation of configuration file
 *
 * The configuration file is read and written, and acquisition and the set of a 
 * set value are done. 
 * @author Yasumichi Akahoshi
 * @date Fri Jan 21 16:34:46 2005
 * $Revision: 1.6 $
 * \endif
 */

/*
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef _CXP_PROFILE_H
#define _CXP_PROFILE_H

#ifdef __cplusplus
extern "C"
{
#endif

#include <glib.h>
#include <glib-object.h>

/**
 * \if japanese
 * @brief CxpProfileΥˡʼ̻Ҥ롣
 *
 * \endif
 * \if english
 * @brief A unique identifier of the CxpProfile type is obtained. 
 *
 * \endif
 */
#define CXP_TYPE_PROFILE				(cxp_profile_get_type ())

/**
 * \if japanese
 * @brief objCxpProfile˥㥹Ȥ롣
 *
 * \endif
 * \if english
 * @brief It is Cast in the CxpProfile type as for obj. 
 *
 * \endif
 */
#define CXP_PROFILE(obj)				(G_TYPE_CHECK_INSTANCE_CAST ((obj), CXP_TYPE_PROFILE, CxpProfile))

/**
 * \if japanese
 * @brief vtableCxpProfileClass˥㥹Ȥ롣
 *
 * \endif
 * \if english
 * @brief It is Cast in the CxpProfileClass type as for vtable. 
 *
 * \endif
 */
#define CXP_PROFILE_CLASS(vtable)		(G_TYPE_CHECK_CLASS_CAST ((vtable), CXP_TYPE_PROFILE, CxpProfileClass))

/**
 * \if japanese
 * @brief objCxpProfileǤ뤫ǧ롣
 *
 * \endif
 * \if english
 * @brief Whether obj is CxpProfile type is confirmed. 
 *
 * \endif
 */
#define CXP_IS_PROFILE(obj)				(G_TYPE_CHECK_INSTANCE_TYPE ((obj), CXP_TYPE_PROFILE))

/**
 * \if japanese
 * @brief vtableCxpProfileClassǤ뤫ǧ롣
 *
 * \endif
 * \if english
 * @brief Whether vtable is CxpProfileClass type is confirmed.
 *
 * \endif
 */
#define CXP_IS_PROFILE_CLASS(vtable)	(G_TYPE_CHECK_CLASS_TYPE ((vtable), CXP_TYPE_PROFILE))

/**
 * \if japanese
 * @brief 󥹥inst顢CxpProfileClass롣
 *
 * \endif
 * \if english
 * @brief The CxpProfileClass type is obtained from instance inst. 
 *
 * \endif
 */
#define CXP_PROFILE_GET_CLASS(inst)		(G_TYPE_INSTANCE_GET_INTERFACE ((inst), CXP_TYPE_PROFILE, CxpProfileClass))

	/**
	 * \if japanese
	 * @brief ե򰷤Υ֥
	 * \endif
	 */
	typedef struct
	{
		GObject parent;
	} CxpProfile;

	/**
	 * \if japanese
	 * @brief ե򰷤Υ饹
	 * \endif
	 */
	typedef struct
	{
		GObjectClass parent;
	} CxpProfileClass;

	GType cxp_profile_get_type (void);

/*
 * Method definitions.
 */
	CxpProfile *cxp_profile_new (const gchar * appname, const gchar *section);
	gint cxp_profile_get_integer (CxpProfile * profile, const gchar * name);
	gchar *cxp_profile_get_string (CxpProfile * profile, const gchar * name);
	void cxp_profile_set_integer (CxpProfile * profile, const gchar * key,
				      gint value);
	void cxp_profile_set_string (CxpProfile * profile, const gchar * key,
				     const gchar * value);
	GHashTable *cxp_profile_get_hash_table (CxpProfile *profile);
#ifdef __cplusplus
}
#endif

#endif				/* _CXP_PROFILE_H */
