/* $Id: cxp-utils.h,v 1.12 2005/09/02 17:24:56 yasumichi Exp $ */
/**
 * \if japanese
 * @file
 * @brief 桼ƥƥؿ
 *
 * @author 
 * @date Fri Jan 21 2005
 * $Revision: 1.12 $
 * \endif
 * \if english
 * @file
 * @brief Utility function group
 *
 * @author Yasumichi Akahoshi
 * @date Fri Jan 21 2005
 * $Revision: 1.12 $
 * \endif
 */


/*
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
 
#ifndef _CXP_UTILS_H
#define _CXP_UTILS_H

#ifdef __cplusplus
extern "C"
{
#endif

#include <gtk/gtk.h>
#include <time.h>

void add_pixmap_directory (const gchar * directory);
GtkWidget *create_pixmap (GtkWidget * widget, const gchar * filename);
GdkPixbuf *create_pixbuf (const gchar * filename);
void cxp_utils_set_filename_filter (const gchar *value);
void cxp_utils_free_filename_filter (void);
gchar *cxp_path_get_basename_of_utf8 (const gchar * file_name);
gchar *cxp_path_get_dirname_of_utf8 (const gchar * file_name);
gchar *cxp_strftime (const time_t * timep);
void *cxp_error_dialog_run_about_file (gchar *filename);
gboolean cxp_remove_file (const gchar *fullpath);
gchar* cxp_utils_make_unique_key (void);
gchar* cxp_get_mime_type_for_file (const gchar* fullpath);
gchar* cxp_get_mime_comment (const gchar *mimetype);
GdkPixbuf* cxp_lookup_icon_from_mime (const gchar *mimetype);
void cxp_cleanup (void);

#ifdef __cplusplus
}
#endif

#endif /* _CXP-UTILS_H */
