/**
 * @file 
 * @brief This file is main source of project.
 *
 * This file contains main function which init cxplorer and run main loop.
 * @author Yasumichi Akahoshi <yasumichi@users.sourceforge.jp>
 * @date 2004
 * $Revision: 1.11 $
 */

/**
 * @mainpage
 * Cxplorer is a file manager based on Gtk+2.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Library General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <cxp.h>
#include <gtk/gtk.h>
#include <glib/gi18n.h>
#include "cxplorer-window.h"

/**
 * main init cxplorer and run main loop.
 * @param argc [in] Count of command line arguments.
 * @param argv [in] Pointer of arguments list.
 * @retval 0 normally terminate.
 * @retval others abnormally terminate.
 */
int main (int argc, char *argv[])
{
	GtkWidget *window;
	gint exit_code;

#ifdef ENABLE_NLS
	bindtextdomain (GETTEXT_PACKAGE, PACKAGE_LOCALE_DIR);
	bind_textdomain_codeset (GETTEXT_PACKAGE, "UTF-8");
	textdomain (GETTEXT_PACKAGE);
#endif

	gtk_set_locale ();
	//g_print ("%s\n", g_getenv("LANG"));
	if (gtk_init_check (&argc, &argv))
	{
		add_pixmap_directory (PACKAGE_PIXMAPS_DIR "/");

		/*
		 * The following code was added by Glade to create one of each component
		 * (except popup menus), just so that you see something after building
		 * the project. Delete any components that you don't want shown initially.
		 */
		window = cxplorer_window_new ();
		g_signal_connect (window, "delete_event", gtk_main_quit, NULL);
		gtk_window_set_title (GTK_WINDOW (window), _("Cxplorer"));
		gtk_widget_show (window);

		gtk_main ();
		cxp_cleanup ();
		exit_code = 0;
	}
	else
	{
		g_printerr (_("It failed in the initialization of gtk +.\n"));
		exit_code = 1;
	}

	return	exit_code;
}
